/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.signals;

import com.mc3699.codmod.Codmod;
import com.mc3699.codmod.signals.Signal;
import com.mc3699.codmod.signals.Signals;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;

public class SignalManager {
    public static final int NUM_SIGNALS = 5;
    private final Map<Signal, Integer> signals = new HashMap<Signal, Integer>();

    public void refresh(Random rand) {
        this.signals.clear();
        for (int i = 0; i < 5; ++i) {
            Signal signal = Signals.ALL_SIGNALS.get(rand.nextInt(0, Signals.ALL_SIGNALS.size()));
            this.signals.put(signal, signal.liveTime());
        }
    }

    public void tick() {
        for (Map.Entry<Signal, Integer> entry : this.signals.entrySet()) {
            Signal signal = entry.getKey();
            int time = entry.getValue();
            this.signals.put(signal, time - 1);
        }
    }

    public Map<Signal, Integer> getSignals() {
        return Map.copyOf(this.signals);
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<Signal, Integer> entry : this.signals.entrySet()) {
            tag.putInt(entry.getKey().id(), entry.getValue().intValue());
        }
        return tag;
    }

    public void deserialize(CompoundTag tag) {
        this.signals.clear();
        for (String key : tag.getAllKeys()) {
            if (!Signals.SIGNALS.containsKey(key)) {
                Codmod.LOGGER.warn("Unknown signal ID: {}", (Object)key);
                continue;
            }
            if (tag.getTagType(key) != 3) {
                Codmod.LOGGER.warn("Invalid tag type for signal data {}: {}", (Object)key, (Object)tag.getTagType(key));
                continue;
            }
            this.signals.put(Signals.SIGNALS.get(key), tag.getInt(key));
        }
    }
}

