/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.technology.coalGenerator;

import com.mc3699.codmod.registry.CodBlockEntities;
import com.mc3699.codmod.technology.foundation.BaseGeneratingMachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CoalGeneratorBlockEntity
extends BaseGeneratingMachineBlockEntity {
    private int burnTime = 0;

    public CoalGeneratorBlockEntity(BlockPos pos, BlockState blockState) {
        super(CodBlockEntities.COAL_GENERATOR.get(), pos, blockState, 1000, 2);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        ServerLevel serverLevel;
        BlockEntity blockEntity;
        if (level instanceof ServerLevel && (blockEntity = (serverLevel = (ServerLevel)level).getBlockEntity(blockPos)) instanceof CoalGeneratorBlockEntity) {
            CoalGeneratorBlockEntity coalGen = (CoalGeneratorBlockEntity)blockEntity;
            if (coalGen.canProduce() && coalGen.burnTime > 0) {
                coalGen.energyStorage.receiveEnergy(coalGen.getEnergyProduction(), false);
                --coalGen.burnTime;
                coalGen.setChanged();
            } else if (coalGen.canProduce()) {
                coalGen.getItemStackHandler().getStackInSlot(0).consume(1, null);
                coalGen.burnTime = 80;
                coalGen.setChanged();
            }
        }
        CoalGeneratorBlockEntity.energyExportTick(level, blockPos, blockState, t);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("burnTime", this.burnTime);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.burnTime = tag.getInt("burnTime");
    }

    @Override
    public int getEnergyProduction() {
        return 2;
    }

    @Override
    public boolean canProduce() {
        return (this.getItemStackHandler().getStackInSlot(0).getItem() == Items.COAL || this.burnTime > 0) && this.getEnergyStored() != this.getMaxEnergyStored();
    }
}

