/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.graphicsMonitor;

import com.mc3699.codmod.registry.CodBlockEntities;
import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class GraphicsMonitorBlockEntity
extends BlockEntity {
    private final NativeImage[] frameBuffers = new NativeImage[]{new NativeImage(NativeImage.Format.RGBA, 1024, 1024, true), new NativeImage(NativeImage.Format.RGBA, 1024, 1024, true)};
    private int activeFrameBuffer = 0;
    private boolean dirty = true;

    public GraphicsMonitorBlockEntity(BlockPos pos, BlockState blockState) {
        super(CodBlockEntities.GRAPHICS_MONITOR.get(), pos, blockState);
    }

    public NativeImage getActiveFramebuffer() {
        return this.frameBuffers[this.activeFrameBuffer];
    }

    public void swapFramebuffer() {
        this.activeFrameBuffer = (this.activeFrameBuffer + 1) % 2;
        this.dirty = true;
        this.setChanged();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("activeBuffer", this.activeFrameBuffer);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("activeBuffer")) {
            this.activeFrameBuffer = tag.getInt("activeBuffer");
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithFullMetadata(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onLoad() {
        super.onLoad();
        this.drawTestPattern();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void drawTestPattern() {
        NativeImage fb = this.getActiveFramebuffer();
        int width = fb.getWidth();
        int height = fb.getHeight();
        int white = GraphicsMonitorBlockEntity.rgba(255, 255, 255, 255);
        int black = GraphicsMonitorBlockEntity.rgba(0, 0, 0, 255);
        for (int x = 0; x < width; ++x) {
            int color = x / 32 % 2 == 0 ? white : black;
            for (int y = 0; y < height; ++y) {
                fb.setPixelRGBA(x, y, -1);
            }
        }
        this.dirty = true;
        this.setChanged();
    }

    private static int rgba(int r, int g, int b, int a) {
        return a << 24 | b << 16 | g << 8 | r;
    }
}

