/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.launchpad;

import com.mc3699.codmod.registry.CodBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public class LaunchPadBlockEntity
extends BlockEntity {
    public static final int SIZE = 27;
    private ItemStackHandler items = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            LaunchPadBlockEntity.this.setChanged();
            if (LaunchPadBlockEntity.this.level != null) {
                LaunchPadBlockEntity.this.level.invalidateCapabilities(LaunchPadBlockEntity.this.worldPosition);
            }
            super.onContentsChanged(slot);
        }
    };

    public LaunchPadBlockEntity(BlockPos pos, BlockState blockState) {
        super(CodBlockEntities.LAUNCH_PAD.get(), pos, blockState);
    }

    public ItemStackHandler getItems() {
        return this.items;
    }

    public void clearItems() {
        this.items = new ItemStackHandler(27);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.items.serializeNBT(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items.deserializeNBT(registries, tag.getCompound("inventory"));
    }
}

