/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.mantleKey;

import com.mc3699.codmod.block.mantleKey.MantleKeyBlock;
import com.mc3699.codmod.block.mantleKey.MantleKeyBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MantleKeyBlockEntityRender
implements BlockEntityRenderer<MantleKeyBlockEntity> {
    private final Random random = new Random();
    private final BlockEntityRendererProvider.Context context;

    public MantleKeyBlockEntityRender(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(MantleKeyBlockEntity mantleKeyBlockEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        poseStack.pushPose();
        Direction facing = (Direction)mantleKeyBlockEntity.getBlockState().getValue((Property)MantleKeyBlock.FACING);
        if (facing == Direction.NORTH) {
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            poseStack.translate(0.0f, 0.0f, -1.0f);
        }
        if (facing == Direction.SOUTH) {
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        if (facing == Direction.EAST) {
            poseStack.translate(1.0f, 0.0f, 1.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        int beamLen = mantleKeyBlockEntity.getBeamLength();
        this.renderBeam(poseStack, multiBufferSource, v, mantleKeyBlockEntity.getLevel().getGameTime(), beamLen);
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(MantleKeyBlockEntity blockEntity) {
        return true;
    }

    public boolean shouldRender(MantleKeyBlockEntity blockEntity, Vec3 cameraPos) {
        return true;
    }

    public AABB getRenderBoundingBox(MantleKeyBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f)).inflate(1000.0);
    }

    private void renderBeam(PoseStack poseStack, MultiBufferSource buffer, float tickDelta, long worldTime, int beamLength) {
        BeaconRenderer.renderBeaconBeam((PoseStack)poseStack, (MultiBufferSource)buffer, (ResourceLocation)BeaconRenderer.BEAM_LOCATION, (float)tickDelta, (float)1.0f, (long)worldTime, (int)0, (int)beamLength, (int)65535, (float)0.2f, (float)0.25f);
    }
}

