/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.opticalDriveInterface;

import com.mc3699.codmod.block.opticalDriveInterface.OpticalDriveInterfaceBlock;
import com.mc3699.codmod.item.OpticalTapeDriveItem;
import com.mc3699.codmod.peripheral.OpticalDriveInterfacePeripheral;
import com.mc3699.codmod.registry.CodBlockEntities;
import dan200.computercraft.api.peripheral.PeripheralCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;

public class OpticalDriveInterfaceBlockEntity
extends BlockEntity {
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.getItem() instanceof OpticalTapeDriveItem;
        }

        protected void onContentsChanged(int slot) {
            OpticalDriveInterfaceBlockEntity.this.setChanged();
            if (OpticalDriveInterfaceBlockEntity.this.level != null) {
                BlockState state = OpticalDriveInterfaceBlockEntity.this.level.getBlockState(OpticalDriveInterfaceBlockEntity.this.getBlockPos());
                OpticalDriveInterfaceBlockEntity.this.level.setBlock(OpticalDriveInterfaceBlockEntity.this.getBlockPos(), (BlockState)state.setValue((Property)OpticalDriveInterfaceBlock.HAS_DISK, (Comparable)Boolean.valueOf(!this.getStackInSlot(slot).isEmpty())), 3);
            }
        }
    };

    public OpticalDriveInterfaceBlockEntity(BlockPos pos, BlockState blockState) {
        super(CodBlockEntities.OPTICAL_DRIVE_INTERFACE.get(), pos, blockState);
    }

    public ItemStack getDisk() {
        return this.inventory.getStackInSlot(0);
    }

    public void setDisk(ItemStack stack) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            OpticalDriveInterfacePeripheral peripheral;
            ServerLevel serverLevel = (ServerLevel)level;
            this.inventory.setStackInSlot(0, stack);
            if (stack.isEmpty() && (peripheral = (OpticalDriveInterfacePeripheral)serverLevel.getCapability(PeripheralCapability.get(), this.getBlockPos(), null)) != null) {
                peripheral.detachIfAttached();
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
    }
}

