/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.server;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ServerBlock
extends Block {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<VerticalPosition> VERTICAL_POSITION = EnumProperty.create((String)"vertical_position", VerticalPosition.class);
    public static final BooleanProperty ONLINE = BooleanProperty.create((String)"online");

    public ServerBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(VERTICAL_POSITION, (Comparable)((Object)VerticalPosition.SINGLE))).setValue((Property)ONLINE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VERTICAL_POSITION, ONLINE});
        super.createBlockStateDefinition(builder);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Player player = pContext.getPlayer();
        Direction facing = Direction.NORTH;
        if (player != null) {
            Direction blockFacing = Direction.fromYRot((double)player.getYRot());
            facing = blockFacing.getOpposite();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.updateVerticalPosition(level, pos);
            this.updateVerticalPosition(level, pos.above());
            this.updateVerticalPosition(level, pos.below());
        }
    }

    private void updateVerticalPosition(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (!(state.getBlock() instanceof ServerBlock)) {
            return;
        }
        boolean hasBelow = level.getBlockState(pos.below()).getBlock() instanceof ServerBlock;
        boolean hasAbove = level.getBlockState(pos.above()).getBlock() instanceof ServerBlock;
        VerticalPosition newPosition = !hasBelow && !hasAbove ? VerticalPosition.SINGLE : (!hasBelow && hasAbove ? VerticalPosition.BOTTOM : (hasBelow && hasAbove ? VerticalPosition.MIDDLE : VerticalPosition.TOP));
        if (state.getValue(VERTICAL_POSITION) != newPosition) {
            level.setBlock(pos, (BlockState)state.setValue(VERTICAL_POSITION, (Comparable)((Object)newPosition)), 3);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockPos above = pos.above();
        BlockPos below = pos.below();
        boolean result = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        if (!level.isClientSide()) {
            this.updateVerticalPosition(level, above);
            this.updateVerticalPosition(level, below);
        }
        return result;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean newOnline = (Boolean)state.getValue((Property)ONLINE) == false;
            this.toggleConnectedBlocks(level, pos, newOnline);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    private void toggleConnectedBlocks(Level level, BlockPos startPos, boolean online) {
        BlockPos pos = startPos;
        while (level.getBlockState(pos.below()).getBlock() instanceof ServerBlock) {
            pos = pos.below();
        }
        while (level.getBlockState(pos).getBlock() instanceof ServerBlock) {
            BlockState state = level.getBlockState(pos);
            level.setBlock(pos, (BlockState)state.setValue((Property)ONLINE, (Comparable)Boolean.valueOf(online)), 3);
            pos = pos.above();
        }
    }

    public static enum VerticalPosition implements StringRepresentable
    {
        SINGLE("single"),
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top");

        private final String name;

        private VerticalPosition(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

