/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.block.subspace_tripmine;

import com.mc3699.codmod.registry.CodDamageTypes;
import com.mc3699.codmod.registry.CodSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class SubspaceTripmineBlock
extends Block {
    public static final BooleanProperty VISIBLE = BooleanProperty.create((String)"visible");
    public static final BooleanProperty ARMED = BooleanProperty.create((String)"armed");
    public static final IntegerProperty BLINK_STATE = IntegerProperty.create((String)"blink_state", (int)0, (int)1);

    public SubspaceTripmineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(true))).setValue((Property)ARMED, (Comparable)Boolean.valueOf(false))).setValue((Property)BLINK_STATE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VISIBLE, ARMED, BLINK_STATE});
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!level.isClientSide && oldState.getBlock() != this) {
            level.scheduleTick(pos, (Block)this, 40);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)ARMED)).booleanValue()) {
            level.playSound(null, pos, (SoundEvent)CodSounds.TRIPMINE_ARMED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false))).setValue((Property)ARMED, (Comparable)Boolean.valueOf(true)), 3);
            level.scheduleTick(pos, (Block)this, 70 + random.nextInt(100));
        } else if (((Boolean)state.getValue((Property)VISIBLE)).booleanValue()) {
            level.playSound(null, pos, (SoundEvent)CodSounds.TRIPMINE_ARMED.get(), SoundSource.BLOCKS, 0.2f, 0.1f);
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false))).setValue((Property)BLINK_STATE, (Comparable)Integer.valueOf(0)), 3);
            level.scheduleTick(pos, (Block)this, 70 + random.nextInt(100));
        } else {
            level.playSound(null, pos, (SoundEvent)CodSounds.TRIPMINE_ARMED.get(), SoundSource.BLOCKS, 0.2f, 0.1f);
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(true))).setValue((Property)BLINK_STATE, (Comparable)Integer.valueOf(1)), 3);
            level.scheduleTick(pos, (Block)this, 10);
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (((Boolean)state.getValue((Property)ARMED)).booleanValue()) {
                this.spawnParticleSphere(serverLevel, pos, 8.0);
                level.playSound(null, pos, (SoundEvent)CodSounds.TRIPMINE.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
                serverLevel.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                DamageSource tripmineDamage = new DamageSource((Holder)level.registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(CodDamageTypes.SUBSPACE_TRIPMINE));
                AABB damageBounds = new AABB(pos).inflate(8.0);
                List nearEntities = serverLevel.getEntitiesOfClass(LivingEntity.class, damageBounds);
                nearEntities.forEach(target -> {
                    if (target.distanceToSqr(pos.getCenter()) <= 64.0) {
                        target.hurt(tripmineDamage, 1000.0f);
                    }
                });
            }
        }
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.box((double)0.1, (double)0.0, (double)0.1, (double)0.9, (double)0.8, (double)0.9);
    }

    public void spawnParticleSphere(ServerLevel serverLevel, BlockPos center, double radius) {
        int radiusCeil = (int)Math.ceil(radius);
        int particleCount = 0;
        int particleLimit = 1000;
        for (int x = -radiusCeil; x <= radiusCeil; ++x) {
            for (int y = -radiusCeil; y <= radiusCeil; ++y) {
                for (int z = -radiusCeil; z <= radiusCeil; ++z) {
                    if (particleCount >= particleLimit) {
                        return;
                    }
                    double distSq = x * x + y * y + z * z;
                    double dist = Math.sqrt(distSq);
                    if (!(dist >= radius - 0.5) || !(dist <= radius + 0.5)) continue;
                    serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 1.0f), 3.0f), (double)(center.getX() + x) + 0.5, (double)(center.getY() + y) + 0.5, (double)(center.getZ() + z) + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    ++particleCount;
                }
            }
        }
    }
}

