/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.client.image;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ImageStuff {
    public static ResourceLocation registerImage(byte[] image, String id) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(image));
        NativeImage nativeImage = ImageStuff.convertNative(bufferedImage);
        DynamicTexture dyn = new DynamicTexture(nativeImage);
        ResourceLocation imageLocation = ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)("dynamic/" + id));
        Minecraft.getInstance().getTextureManager().register(imageLocation, (AbstractTexture)dyn);
        return imageLocation;
    }

    private static NativeImage convertNative(BufferedImage img) {
        NativeImage n = new NativeImage(img.getWidth(), img.getHeight(), true);
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                int argb = img.getRGB(x, y);
                int abgr = argb & 0xFF000000 | (argb & 0xFF0000) >> 16 | argb & 0xFF00 | (argb & 0xFF) << 16;
                n.setPixelRGBA(x, y, abgr);
            }
        }
        return n;
    }
}

