/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;

public class BloodParticle
extends TextureSheetParticle {
    private boolean hasHitGround = false;
    private int groundTimer = 0;

    protected BloodParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.setSpriteFromAge(spriteSet);
        this.lifetime = 40;
        this.gravity = (0.25f + this.random.nextFloat()) * 0.8f;
        this.quadSize = (0.35f + this.random.nextFloat()) * 0.2f;
        this.xd = ((double)this.random.nextFloat() - 0.5) * 0.02;
        this.yd = -0.25;
        this.zd = ((double)this.random.nextFloat() - 0.5) * 0.02;
    }

    public void tick() {
        if (!this.hasHitGround && this.onGround) {
            this.hasHitGround = true;
            this.groundTimer = 0;
            this.xd = 0.0;
            this.yd = 0.0;
            this.zd = 0.0;
        }
        if (this.hasHitGround) {
            ++this.groundTimer;
            this.alpha = 1.0f - (float)this.groundTimer / 20.0f;
            if (this.groundTimer > 20) {
                this.remove();
            }
        }
        super.tick();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new BloodParticle(clientLevel, pX, pY, pZ, this.spriteSet, pXSpeed, pYSpeed, pZSpeed);
        }
    }
}

