/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.colors;

import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ColorManager {
    private static int foliageColor = 4764952;
    private static int grassColor = 9551193;
    private static boolean useCustomFoliage = false;
    private static boolean useCustomGrass = false;

    public static void setFoliageColor(int color) {
        foliageColor = color;
        useCustomFoliage = true;
    }

    public static void setGrassColor(int color) {
        grassColor = color;
        useCustomGrass = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getFoliageColor(BlockState state, BlockAndTintGetter world, BlockPos pos, int tintIndex) {
        if (useCustomFoliage || world == null || pos == null) {
            return foliageColor;
        }
        return BiomeColors.getAverageFoliageColor((BlockAndTintGetter)world, (BlockPos)pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getGrassColor(BlockState state, BlockAndTintGetter world, BlockPos pos, int tintIndex) {
        if (useCustomGrass || world == null || pos == null) {
            return grassColor;
        }
        return BiomeColors.getAverageGrassColor((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public static void resetFoliageColor() {
        useCustomFoliage = false;
    }

    public static void resetGrassColor() {
        useCustomGrass = false;
    }
}

