/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.commands;

import com.mc3699.codmod.network.ImageFileRequestPayload;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;

public class ImageCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sendImage").requires(src -> src.hasPermission(3))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"y", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"scaleX", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"scaleY", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"path", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            List<UUID> targetUUIDs = EntityArgument.getPlayers((CommandContext)ctx, (String)"targets").stream().map(Entity::getUUID).toList();
            int x = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"x");
            int y = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"y");
            int scaleX = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"scaleX");
            int scaleY = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"scaleY");
            int duration = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration");
            String path = StringArgumentType.getString((CommandContext)ctx, (String)"path");
            PacketDistributor.sendToPlayer((ServerPlayer)sender, (CustomPacketPayload)new ImageFileRequestPayload(targetUUIDs, path, x, y, scaleX, scaleY, duration), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return 1;
        })))))))));
    }
}

