/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.effect;

import com.mc3699.codmod.registry.CodDamageTypes;
import com.mc3699.codmod.registry.CodMobEffects;
import com.mc3699.codmod.registry.CodParticles;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class BleedingEffect
extends MobEffect {
    private final Map<UUID, Vec3> lastPositions = new HashMap<UUID, Vec3>();

    public BleedingEffect() {
        super(MobEffectCategory.HARMFUL, -1);
    }

    public ParticleOptions createParticleOptions(MobEffectInstance effectInstance) {
        return (ParticleOptions)CodParticles.BLOOD_PARTICLE.get();
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MobEffectInstance effectInstance = livingEntity.getEffect(CodMobEffects.BLEEDING);
        if (effectInstance != null) {
            int remainingDuration = effectInstance.getDuration();
            Vec3 currentPosition = livingEntity.position();
            Vec3 lastPos = this.lastPositions.get(livingEntity.getUUID());
            boolean isMoving = false;
            if (lastPos != null) {
                double distanceMoved = currentPosition.distanceToSqr(lastPos);
                isMoving = distanceMoved > 0.001;
            }
            this.lastPositions.put(livingEntity.getUUID(), currentPosition);
            if (isMoving && remainingDuration % 10 == 0 || !isMoving && remainingDuration % 40 == 0) {
                float damage = 1.0f + (float)amplifier;
                DamageSource bleedDamage = new DamageSource((Holder)livingEntity.level().registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(CodDamageTypes.BLEEDING));
                Vec3 motion = livingEntity.getDeltaMovement();
                livingEntity.hurt(bleedDamage, damage);
                livingEntity.setDeltaMovement(motion);
            }
            if (remainingDuration % 3 == 0 && !livingEntity.level().isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)livingEntity.level();
                for (int i = 0; i < 3; ++i) {
                    double offsetX = (livingEntity.getRandom().nextDouble() - 0.5) * (double)livingEntity.getBbWidth();
                    double offsetY = livingEntity.getRandom().nextDouble() * (double)livingEntity.getBbHeight();
                    double offsetZ = (livingEntity.getRandom().nextDouble() - 0.5) * (double)livingEntity.getBbWidth();
                    serverLevel.sendParticles((ParticleOptions)CodParticles.BLOOD_PARTICLE.get(), livingEntity.getX() + offsetX, livingEntity.getY() + offsetY, livingEntity.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

