/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.effect;

import com.mc3699.codmod.registry.CodMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

public class InsanityMobEffect
extends MobEffect {
    private static final double ROTATION_CHANCE = 0.02;
    private static final double TARGET_SEARCH_CHANCE = 0.025;
    private static final int ROTATION_DAMAGE = 2;
    private static final int EXPIRE_DAMAGE = 10;
    private static final int SEARCH_RADIUS = 5;
    private static final double MOVEMENT_SPEED = 0.6;

    public InsanityMobEffect() {
        super(MobEffectCategory.HARMFUL, -1);
        this.registerAttributeModifier((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, "effect.insanity_0", -2.0, AttributeModifier.Operation.ADD_VALUE);
        this.registerAttributeModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, "effect.insanity_1", -3.0, AttributeModifier.Operation.ADD_VALUE);
        this.registerAttributeModifier((Holder<Attribute>)Attributes.FOLLOW_RANGE, "effect.insanity_2", -10.0, AttributeModifier.Operation.ADD_VALUE);
        this.registerAttributeModifier((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, "effect.insanity_3", -1.5, AttributeModifier.Operation.ADD_VALUE);
        this.registerAttributeModifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, "effect.insanity_4", -0.05, AttributeModifier.Operation.ADD_VALUE);
        this.registerAttributeModifier((Holder<Attribute>)Attributes.SPAWN_REINFORCEMENTS_CHANCE, "effect.insanity_5", -5.0, AttributeModifier.Operation.ADD_VALUE);
        this.registerAttributeModifier((Holder<Attribute>)Attributes.ARMOR, "effect.insanity_6", -0.55, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public ParticleOptions createParticleOptions(MobEffectInstance effectInstance) {
        return ParticleTypes.NOTE;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        InsanityMobEffect.updateInsanity(entity);
        return super.applyEffectTick(entity, amplifier);
    }

    public void onMobHurt(LivingEntity entity, int amplifier, DamageSource damageSource, float damage) {
        InsanityMobEffect.playHurtSound((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        InsanityMobEffect.handleEffectEnd((Entity)event.getEntity(), event.getEffectInstance());
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        InsanityMobEffect.handleEffectEnd((Entity)event.getEntity(), event.getEffectInstance());
    }

    private static void handleEffectEnd(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance != null && effectInstance.getEffect().is(CodMobEffects.INSANITY)) {
            InsanityMobEffect.applyExpireEffects(entity);
        }
    }

    private static void updateInsanity(LivingEntity entity) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        entity.setSprinting(false);
        if (InsanityMobEffect.shouldRotate()) {
            InsanityMobEffect.randomizeRotation((Entity)entity);
            entity.hurt(new DamageSource(world.holderOrThrow(DamageTypes.WITHER)), 2.0f);
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            InsanityMobEffect.randomizeNavigation(mob, x, y, z);
        }
        if (InsanityMobEffect.shouldSearchForTargets()) {
            InsanityMobEffect.searchForTargets((Entity)entity, (LevelAccessor)world, x, y, z);
        }
    }

    private static boolean shouldRotate() {
        return Math.random() < 0.02;
    }

    private static boolean shouldSearchForTargets() {
        return Math.random() < 0.025;
    }

    private static void randomizeRotation(Entity entity) {
        RandomSource random = RandomSource.create();
        float yaw = Mth.nextInt((RandomSource)random, (int)-180, (int)180);
        float pitch = Mth.nextInt((RandomSource)random, (int)-180, (int)180);
        entity.setYRot(yaw);
        entity.setXRot(pitch);
        entity.setYBodyRot(yaw);
        entity.setYHeadRot(yaw);
        entity.yRotO = yaw;
        entity.xRotO = pitch;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.yBodyRotO = yaw;
            livingEntity.yHeadRotO = yaw;
        }
    }

    private static void randomizeNavigation(Mob mob, double x, double y, double z) {
        RandomSource random = RandomSource.create();
        double newX = x + (double)Mth.nextInt((RandomSource)random, (int)-5, (int)5);
        double newZ = z + (double)Mth.nextInt((RandomSource)random, (int)-5, (int)5);
        mob.getNavigation().moveTo(newX, y, newZ, 0.6);
    }

    private static void searchForTargets(Entity entity, LevelAccessor world, double x, double y, double z) {
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        AABB searchBox = new AABB(x + 5.0, y + 5.0, z + 5.0, x - 5.0, y - 5.0, z - 5.0);
        for (Entity nearby : world.getEntities(entity, searchBox)) {
            if (!(nearby instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)nearby;
            mob.setTarget(target);
            break;
        }
    }

    private static void applyExpireEffects(Entity entity) {
        LivingEntity livingEntity;
        if (entity == null) {
            return;
        }
        entity.hurt(new DamageSource(entity.level().holderOrThrow(DamageTypes.WITHER)), 10.0f);
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getHealth() > 0.0f) {
            InsanityMobEffect.playExpireSound((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
        }
    }

    private static void playHurtSound(LevelAccessor world, double x, double y, double z) {
        InsanityMobEffect.playSound(world, x, y, z, "codmod:plinkypoo", SoundSource.NEUTRAL, 1.0f, (float)(Math.random() * (double)2.3f));
    }

    private static void playExpireSound(LevelAccessor world, double x, double y, double z) {
        InsanityMobEffect.playSound(world, x, y, z, "codmod:insane", SoundSource.PLAYERS, 0.3f, 0.75f);
    }

    private static void playSound(LevelAccessor world, double x, double y, double z, String soundId, SoundSource source, float volume, float pitch) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
        SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)soundId));
        if (!level.isClientSide()) {
            level.playSound(null, pos, soundEvent, source, volume, pitch);
        } else {
            level.playLocalSound(x, y, z, soundEvent, source, volume, pitch, false);
        }
    }

    private void registerAttributeModifier(Holder<Attribute> attributeHolder, String name, double amount, AttributeModifier.Operation operation) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)name);
        this.addAttributeModifier(attributeHolder, id, amount, operation);
    }
}

