/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity;

import com.mc3699.codmod.entity.itemProjectile.ItemProjectileEntity;
import com.mc3699.codmod.handlers.CodScheduler;
import com.mc3699.codmod.handlers.beamStuff.RenderBeamPayload;
import com.mc3699.codmod.registry.CodSounds;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.PacketDistributor;

public class MarksmanRevolverCoinEntity
extends ItemProjectileEntity {
    private static final EntityDataAccessor<Integer> RICO_COUNT = SynchedEntityData.defineId(MarksmanRevolverCoinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int MAX_RICOCHETS = 6;
    private static final double SEARCH_RADIUS = 16.0;
    private static final double BASE_DAMAGE = 10.0;
    private transient Set<UUID> chainHitSet = null;

    public MarksmanRevolverCoinEntity(EntityType<? extends ItemProjectileEntity> entityType, Level level) {
        super(entityType, level, new ItemStack((ItemLike)Items.COD, 1), 0, 0, false);
    }

    public void hit(Player player) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.getServer().execute(() -> this.handleHit(serverLevel, player));
    }

    private void handleHit(ServerLevel serverLevel, Player player) {
        Entity nextTarget;
        if (this.chainHitSet == null) {
            this.chainHitSet = new HashSet<UUID>();
            if (player != null) {
                this.chainHitSet.add(player.getUUID());
            }
            this.chainHitSet.add(this.getUUID());
        }
        if ((nextTarget = this.getNextTarget(serverLevel, player, (Entity)this)) != null) {
            if (nextTarget instanceof MarksmanRevolverCoinEntity) {
                MarksmanRevolverCoinEntity coin = (MarksmanRevolverCoinEntity)nextTarget;
                int currentCount = Math.min((Integer)this.getEntityData().get(RICO_COUNT), 6);
                int newCount = Math.min(currentCount + 1, 6);
                PacketDistributor.sendToPlayersTrackingEntity((Entity)coin, (CustomPacketPayload)new RenderBeamPayload(this.position(), coin.position().add(0.0, (double)coin.getEyeHeight(), 0.0), 0.05f, 10, 0xFFFF00), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.propagateChainToCoin(coin, this.chainHitSet, newCount);
                CodScheduler.schedule(2, () -> serverLevel.getServer().execute(() -> coin.handleHit(serverLevel, player)));
            } else if (nextTarget instanceof LivingEntity) {
                Entity target;
                int count = (Integer)this.getEntityData().get(RICO_COUNT);
                if (count <= 0) {
                    count = 1;
                }
                count = Math.min(count, 6);
                for (int i = 0; i < count && (target = this.getNextTarget(serverLevel, player, (Entity)this)) != null; ++i) {
                    PacketDistributor.sendToPlayersTrackingEntity((Entity)target, (CustomPacketPayload)new RenderBeamPayload(this.position(), target.position().add(0.0, (double)target.getEyeHeight(), 0.0), 0.05f, 10, 0xFFFF00), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    serverLevel.playSound(null, player.blockPosition(), (SoundEvent)CodSounds.SUPRESSED_GUNSHOT.value(), SoundSource.MASTER, 0.3f, 1.0f);
                    if (target instanceof LivingEntity) {
                        LivingEntity hitLiving = (LivingEntity)target;
                        double dmg = 10.0 * (1.0 + (double)((Integer)this.getEntityData().get(RICO_COUNT)).intValue());
                        hitLiving.hurt(serverLevel.damageSources().playerAttack(player), (float)dmg);
                        this.chainHitSet.add(hitLiving.getUUID());
                    }
                    this.chainHitSet.add(target.getUUID());
                }
            }
        }
        this.discard();
        serverLevel.playSound(null, this.blockPosition(), (SoundEvent)CodSounds.COIN.value(), SoundSource.MASTER, 2.0f, 1.0f);
        serverLevel.playSound(null, player.blockPosition(), (SoundEvent)CodSounds.SUPRESSED_GUNSHOT.value(), SoundSource.MASTER, 0.1f, 2.0f);
    }

    private void propagateChainToCoin(MarksmanRevolverCoinEntity targetCoin, Set<UUID> currentChain, int newRicochetCount) {
        HashSet<UUID> copy = new HashSet<UUID>(currentChain);
        copy.add(targetCoin.getUUID());
        targetCoin.chainHitSet = copy;
        targetCoin.getEntityData().set(RICO_COUNT, (Object)newRicochetCount);
    }

    private Entity getNextTarget(ServerLevel serverLevel, Player firingEntity, Entity origin) {
        AABB searchArea = new AABB(origin.blockPosition()).inflate(16.0);
        List nearTargets = serverLevel.getEntities((Entity)this, searchArea, e -> {
            if (firingEntity != null && e.is((Entity)firingEntity)) {
                return false;
            }
            if (!e.isAlive()) {
                return false;
            }
            if (this.chainHitSet != null && this.chainHitSet.contains(e.getUUID())) {
                return false;
            }
            return e != this;
        });
        MarksmanRevolverCoinEntity nearestCoin = null;
        double closestCoinDist = Double.MAX_VALUE;
        MarksmanRevolverCoinEntity nearestLiving = null;
        double closestLivingDist = Double.MAX_VALUE;
        for (Entity entity : nearTargets) {
            BlockHitResult result;
            LivingEntity living;
            double dist;
            if (entity instanceof MarksmanRevolverCoinEntity) {
                MarksmanRevolverCoinEntity coin = (MarksmanRevolverCoinEntity)entity;
                int coinCount = (Integer)coin.getEntityData().get(RICO_COUNT);
                if (coinCount >= 6 || !((dist = origin.position().distanceTo(coin.position())) < closestCoinDist)) continue;
                closestCoinDist = dist;
                nearestCoin = coin;
                continue;
            }
            if (!(entity instanceof LivingEntity) || (living = (LivingEntity)entity).isDeadOrDying() || living.isInvulnerable() || (result = serverLevel.clip(new ClipContext(origin.position(), living.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this))).getType() != HitResult.Type.MISS || !((dist = origin.position().distanceTo(living.getEyePosition())) < closestLivingDist)) continue;
            closestLivingDist = dist;
            nearestLiving = living;
        }
        return nearestCoin != null ? nearestCoin : nearestLiving;
    }

    protected double getDefaultGravity() {
        return 0.06;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(RICO_COUNT, (Object)0);
        super.defineSynchedData(builder);
    }
}

