/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity;

import com.mc3699.codmod.handlers.NullFangCallbacks;
import com.mc3699.codmod.registry.CodEntities;
import com.mc3699.codmod.registry.CodItems;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class NullFangHookEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)CodItems.NULLFANG.get());
    private static final float KNOCKBACK_MULTIPLIER = 0.6f;
    private static final float VERTICAL_KNOCKBACK = 0.1f;
    private int knockback = 0;

    public NullFangHookEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public NullFangHookEntity(EntityType<? extends AbstractArrow> type, double x, double y, double z, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, x, y, z, world, PROJECTILE_ITEM, firedFromWeapon);
        this.initializeKnockback(world, firedFromWeapon);
    }

    public NullFangHookEntity(EntityType<? extends AbstractArrow> type, LivingEntity entity, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, entity, world, PROJECTILE_ITEM, firedFromWeapon);
        this.initializeKnockback(world, firedFromWeapon);
    }

    private void initializeKnockback(Level world, @Nullable ItemStack weapon) {
        if (weapon != null) {
            int knockbackLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), (ItemStack)weapon);
            this.setKnockback(knockbackLevel);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)CodItems.NULLFANG.get());
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    protected void doKnockback(LivingEntity target, DamageSource source) {
        if (this.knockback > 0) {
            this.applyCustomKnockback(target);
        } else {
            super.doKnockback(target, source);
        }
    }

    private void applyCustomKnockback(LivingEntity target) {
        double resistance = Math.max(0.0, 1.0 - target.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
        Vec3 direction = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
        Vec3 knockbackVec = direction.scale((double)((float)this.knockback * 0.6f) * resistance);
        if (knockbackVec.lengthSqr() > 0.0) {
            target.push(knockbackVec.x, (double)0.1f, knockbackVec.z);
        }
    }

    public void onHitEntity(EntityHitResult result) {
        LivingEntity hitEntity;
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity && (hitEntity = (LivingEntity)entity).isInvulnerable()) {
            this.discard();
            return;
        }
        NullFangCallbacks.onHitEntity((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), result.getEntity(), this.getOwner());
    }

    public void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        NullFangCallbacks.onHitBlock((LevelAccessor)this.level(), result.getBlockPos(), this.getOwner());
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            this.discard();
        }
    }

    public static NullFangHookEntity shoot(Level world, LivingEntity entity, RandomSource random) {
        return NullFangHookEntity.shoot(world, entity, random, 1.5f, 1.0, 0);
    }

    public static NullFangHookEntity shoot(Level world, LivingEntity entity, RandomSource random, float pullingPower) {
        return NullFangHookEntity.shoot(world, entity, random, pullingPower * 1.5f, 1.0, 0);
    }

    public static NullFangHookEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        NullFangHookEntity arrow = new NullFangHookEntity((EntityType<? extends AbstractArrow>)((EntityType)CodEntities.NULLFANG_HOOK.get()), entity, world, null);
        Vec3 direction = entity.getViewVector(1.0f);
        arrow.shoot(direction.x, direction.y, direction.z, power * 2.0f, 0.0f);
        arrow.setSilent(true);
        arrow.setCritArrow(false);
        arrow.setBaseDamage(damage);
        arrow.setKnockback(knockback);
        world.addFreshEntity((Entity)arrow);
        return arrow;
    }

    public static NullFangHookEntity shootAtTarget(LivingEntity shooter, LivingEntity target) {
        NullFangHookEntity arrow = new NullFangHookEntity((EntityType<? extends AbstractArrow>)((EntityType)CodEntities.NULLFANG_HOOK.get()), shooter, shooter.level(), null);
        double dx = target.getX() - shooter.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - shooter.getZ();
        double horizontalDistance = Math.hypot(dx, dz);
        arrow.shoot(dx, dy - arrow.getY() + horizontalDistance * (double)0.2f, dz, 3.0f, 12.0f);
        arrow.setSilent(true);
        arrow.setBaseDamage(1.0);
        arrow.setKnockback(0);
        arrow.setCritArrow(false);
        shooter.level().addFreshEntity((Entity)arrow);
        return arrow;
    }
}

