/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.applicant;

import com.mc3699.codmod.entity.applicant.ApplicantEntity;
import com.mc3699.codmod.registry.CodItems;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ApplicantEntityRenderer
extends EntityRenderer<ApplicantEntity> {
    private final ItemRenderer itemRenderer;
    private final Random random = new Random();

    public ApplicantEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public ResourceLocation getTextureLocation(ApplicantEntity applicantEntity) {
        return ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"textures/item/application.png");
    }

    public void render(ApplicantEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        float glitchBounds = 0.05f;
        poseStack.translate((double)this.random.nextFloat(-glitchBounds, glitchBounds), 1.5, (double)(0.0f + this.random.nextFloat(-glitchBounds, glitchBounds)));
        poseStack.scale(10.0f, 12.0f, 10.0f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        ItemStack stackItem = new ItemStack((ItemLike)CodItems.APPLICATION.get());
        BakedModel model = this.itemRenderer.getModel(stackItem, entity.level(), null, 0);
        this.itemRenderer.render(stackItem, ItemDisplayContext.GROUND, false, poseStack, bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

