/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.codmissile;

import com.mc3699.codmod.entity.parachuteChest.ParachuteChestEntity;
import com.mc3699.codmod.registry.CodEntities;
import com.mc3699.codmod.registry.CodSounds;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;

public class CodMissileEntity
extends Entity {
    private static final int LAUNCH_TIMER = 60;
    private static final double ASCENT_SPEED = 1.5;
    private static final double TERMINAL_SPEED = -2.0;
    private final ItemStackHandler items;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int phaseTime;
    private int phase;
    private String function;
    private String argument;

    public CodMissileEntity(EntityType<CodMissileEntity> type, Level level, double targetX, double targetY, double targetZ, String function, @Nullable String argument, @Nullable ItemStackHandler items) {
        super(type, level);
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
        this.function = function;
        this.argument = argument;
        this.items = items;
    }

    public boolean isNoGravity() {
        return true;
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ++this.phaseTime;
            switch (this.phase) {
                case 0: {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.position().x, this.position().y, this.position().z, 10, 0.0, -0.1, 0.0, 0.01);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.WHITE_SMOKE, this.position().x, this.position().y, this.position().z, 20, 0.0, -0.1, 0.0, 0.02);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, this.position().x, this.position().y, this.position().z, 50, 0.0, -0.1, 0.0, 0.02);
                    this.move(MoverType.SELF, this.getDeltaMovement());
                    if (this.phaseTime <= 60) break;
                    this.phase = 1;
                    this.phaseTime = 0;
                    this.setDeltaMovement(0.0, 1.5, 0.0);
                    break;
                }
                case 1: {
                    if (this.phaseTime == 2) {
                        serverLevel.playSound(null, BlockPos.containing((Position)this.position()), (SoundEvent)CodSounds.MISSILE_LAUNCH.get(), SoundSource.PLAYERS, 100.0f, 1.0f);
                        serverLevel.playSound(null, BlockPos.containing((Position)this.position()), SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.PLAYERS, 10.0f, 1.0f);
                    }
                    this.move(MoverType.SELF, this.getDeltaMovement());
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, this.position().x, this.position().y, this.position().z, 300, 0.0, -0.1, 0.0, 0.01);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, this.position().x, this.position().y, this.position().z, 300, 0.0, -0.1, 0.0, 0.03);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.position().x, this.position().y, this.position().z, 100, 0.0, -3.0, 0.0, 0.05);
                    if (!(this.getY() >= 320.0)) break;
                    this.phase = 2;
                    this.phaseTime = 0;
                    this.setDeltaMovement(0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    this.setPos(this.targetX + 0.5, 320.0, this.targetZ + 0.5);
                    this.phase = 3;
                    this.phaseTime = 0;
                    this.setDeltaMovement(0.0, -2.0, 0.0);
                    break;
                }
                case 3: {
                    if (this.phaseTime == 2) {
                        serverLevel.playSound(null, BlockPos.containing((Position)this.position()), (SoundEvent)CodSounds.MISSILE_LAUNCH.get(), SoundSource.PLAYERS, 100.0f, 1.0f);
                    }
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.position().x, this.position().y, this.position().z, 100, 0.0, 2.0, 0.0, 0.3);
                    this.move(MoverType.SELF, this.getDeltaMovement());
                    if (this.function.equals("delivery")) {
                        this.performFunction(serverLevel, this.function, "");
                    }
                    if (!this.onGround() && !(this.getY() <= this.targetY)) break;
                    this.performFunction(serverLevel, this.function, this.argument);
                }
            }
        }
    }

    protected void performFunction(ServerLevel serverLevel, String function, String argument) {
        switch (function) {
            case "cod_explosion": {
                this.explode(serverLevel);
                break;
            }
            case "delivery": {
                this.summonParachuteChest(serverLevel, this.items);
                break;
            }
            case "summon": {
                this.summonEntity(serverLevel, argument);
            }
        }
        serverLevel.playSound(null, BlockPos.containing((Position)this.position()), SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.PLAYERS, 50.0f, 1.0f);
        this.discard();
    }

    private List<ItemStack> fillInventory(Item item, int startSlot, int endSlot) {
        ArrayList<ItemStack> filledInventory = new ArrayList<ItemStack>(27);
        for (int i = startSlot; i < endSlot; ++i) {
            filledInventory.add(new ItemStack((ItemLike)item, 64));
        }
        return filledInventory;
    }

    protected void summonParachuteChest(ServerLevel serverLevel, ItemStackHandler items) {
        ParachuteChestEntity chestEntity = new ParachuteChestEntity((EntityType<ParachuteChestEntity>)((EntityType)CodEntities.PARACHUTE_CHEST.get()), (Level)serverLevel, items);
        chestEntity.setPos(this.position());
        serverLevel.addFreshEntity((Entity)chestEntity);
    }

    protected void summonEntity(ServerLevel serverLevel, String entityID) {
        EntityType entityType = EntityType.byString((String)entityID).orElse(EntityType.COD);
        Entity entity = entityType.create((Level)serverLevel);
        if (entity != null) {
            entity.setPos(this.position());
            serverLevel.addFreshEntity(entity);
        }
    }

    protected void placeBarrel(ServerLevel serverLevel, BlockPos placePos, List<ItemStack> items) {
        serverLevel.setBlock(placePos, Blocks.BARREL.defaultBlockState(), 3);
        BarrelBlockEntity barrelBlockEntity = (BarrelBlockEntity)serverLevel.getBlockEntity(placePos);
        int slot = 0;
        for (ItemStack item : items) {
            barrelBlockEntity.setItem(slot, item);
            ++slot;
        }
    }

    protected void explode(ServerLevel serverLevel) {
        Vec3 codSpawnPos = this.position().add(0.0, 1.0, 0.0);
        serverLevel.playSound(null, BlockPos.containing((Position)codSpawnPos), SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.PLAYERS, 10.0f, 1.0f);
        int gridSize = 16;
        for (int xIndex = 0; xIndex < gridSize; ++xIndex) {
            for (int zIndex = 0; zIndex < gridSize; ++zIndex) {
                double xOffset = (double)xIndex - (double)gridSize / 2.0 + 0.5;
                double zOffset = (double)zIndex - (double)gridSize / 2.0 + 0.5;
                Vec3 spawnPos = codSpawnPos.add(xOffset, 0.0, zOffset);
                Cod cod = new Cod(EntityType.COD, (Level)serverLevel);
                cod.setPos(spawnPos);
                int randomVelX = serverLevel.random.nextInt(-4, 5);
                int randomVelZ = serverLevel.random.nextInt(-4, 5);
                int randomHeight = serverLevel.random.nextInt(8, 25);
                cod.setDeltaMovement((double)randomVelX * 0.1, (double)randomHeight * 0.05, (double)randomVelZ * 0.1);
                serverLevel.addFreshEntity((Entity)cod);
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.targetX = compoundTag.getDouble("targetX");
        this.targetY = compoundTag.getDouble("targetY");
        this.targetZ = compoundTag.getDouble("targetZ");
        this.phase = compoundTag.getInt("phase");
        this.phaseTime = compoundTag.getInt("phaseTime");
        this.function = compoundTag.getString("function");
        this.argument = compoundTag.getString("argument");
        if (compoundTag.contains("inventory")) {
            this.items.deserializeNBT((HolderLookup.Provider)this.level().registryAccess(), compoundTag.getCompound("inventory"));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putDouble("targetX", this.targetX);
        compoundTag.putDouble("targetY", this.targetY);
        compoundTag.putDouble("targetZ", this.targetZ);
        compoundTag.putInt("phase", this.phase);
        compoundTag.putInt("phaseTime", this.phaseTime);
        compoundTag.putString("function", this.function);
        compoundTag.putString("argument", this.argument);
        compoundTag.put("inventory", (Tag)this.items.serializeNBT((HolderLookup.Provider)this.level().registryAccess()));
    }
}

