/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.friendlyFace;

import com.mc3699.codmod.entity.friendlyFace.FriendlyFaceEntity;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class AttackForTimeGoal
extends Goal {
    private final FriendlyFaceEntity entity;
    private final Level level;
    private final double approachDistance;
    private final double attackSpeed;
    private final Random random;
    private Player target;

    public AttackForTimeGoal(FriendlyFaceEntity entity, Level level, double approachDistance, double attackSpeed) {
        this.entity = entity;
        this.level = level;
        this.approachDistance = approachDistance;
        this.attackSpeed = attackSpeed;
        this.random = new Random();
        this.entity.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)entity, Player.class, false));
    }

    public boolean canUse() {
        this.target = (Player)this.entity.getTarget();
        return this.target != null && this.target.isAlive();
    }

    public void start() {
        this.entity.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.entity.getMaxHeadXRot());
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && this.entity.chaseTime > 0;
    }

    public void tick() {
        if (this.target != null) {
            this.entity.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.entity.getMaxHeadXRot());
            if (this.entity.distanceToSqr((Entity)this.target) < this.approachDistance * this.approachDistance) {
                this.entity.getNavigation().moveTo((Entity)this.target, this.attackSpeed);
                if (this.entity.distanceToSqr((Entity)this.target) < 2.0) {
                    this.entity.doHurtTarget((Entity)this.target);
                }
            }
            --this.entity.chaseTime;
            if (this.entity.chaseTime <= 0) {
                this.entity.discard();
            }
        }
    }

    public void stop() {
        this.target = null;
        this.entity.getNavigation().stop();
    }
}

