/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.itemProjectile;

import com.mc3699.codmod.registry.CodDamageTypes;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ItemProjectileEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> BOUNCE_COUNT = SynchedEntityData.defineId(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MAX_BOUNCE = SynchedEntityData.defineId(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<ItemStack> CARRIED_ITEM = SynchedEntityData.defineId(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> DAMAGE = SynchedEntityData.defineId(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SHOULD_DROP = SynchedEntityData.defineId(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final double SPEED_THRESHOLD = 1.0E-4;
    private Vec3 lastPosition;

    public ItemProjectileEntity(EntityType<? extends ItemProjectileEntity> entityType, Level level, ItemStack carriedItem, int bounceCount, int damage, boolean dropItem) {
        super(entityType, level);
        this.setCarriedItem(carriedItem.copy());
        this.getEntityData().set(MAX_BOUNCE, (Object)bounceCount);
        this.getEntityData().set(DAMAGE, (Object)damage);
        this.getEntityData().set(SHOULD_DROP, (Object)dropItem);
        this.setCustomName(carriedItem.getDisplayName());
        this.lastPosition = this.position();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BOUNCE_COUNT, (Object)0);
        builder.define(MAX_BOUNCE, (Object)0);
        builder.define(CARRIED_ITEM, (Object)ItemStack.EMPTY);
        builder.define(DAMAGE, (Object)0);
        builder.define(SHOULD_DROP, (Object)false);
    }

    public ItemStack getCarriedItem() {
        return ((ItemStack)this.getEntityData().get(CARRIED_ITEM)).copy();
    }

    private void setCarriedItem(ItemStack item) {
        this.getEntityData().set(CARRIED_ITEM, (Object)item.copy());
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    protected void onHitBlock(BlockHitResult result) {
        if (!this.level().isClientSide) {
            int bounces = (Integer)this.getEntityData().get(BOUNCE_COUNT);
            int maxBounce = (Integer)this.getEntityData().get(MAX_BOUNCE);
            this.setOnGround(false);
            this.getEntityData().set(BOUNCE_COUNT, (Object)(bounces + 1));
            Vec3 velocity = this.getDeltaMovement();
            Vec3 normal = Vec3.atLowerCornerOf((Vec3i)result.getDirection().getNormal());
            double dot = velocity.dot(normal);
            this.setPos(this.position().add(normal.scale(0.5)));
            Vec3 reflected = velocity.subtract(normal.scale(2.0 * dot));
            this.setDeltaMovement(reflected);
            if (bounces >= maxBounce) {
                ServerLevel serverLevel = (ServerLevel)this.level();
                ItemStack item = this.getCarriedItem();
                if (!item.isEmpty() && ((Boolean)this.getEntityData().get(SHOULD_DROP)).booleanValue()) {
                    serverLevel.addFreshEntity((Entity)new ItemEntity((Level)serverLevel, this.getX(), this.getY(), this.getZ(), item));
                }
                this.discard();
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            Player player;
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = result.getEntity();
            if ((Integer)this.getEntityData().get(DAMAGE) > 0) {
                DamageSource damage = new DamageSource((Holder)serverLevel.registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(CodDamageTypes.ITEM_PROJECTILE), null, (Entity)this);
                entity.hurt(damage, (float)((Integer)this.getEntityData().get(DAMAGE)).intValue());
            }
            if (entity instanceof Player && (player = (Player)entity) != this.getOwner()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ItemStack item = this.getCarriedItem();
                    if (!item.isEmpty() && ((Boolean)this.getEntityData().get(SHOULD_DROP)).booleanValue()) {
                        serverPlayer.addItem(item);
                    }
                }
                this.discard();
            }
        }
    }

    protected boolean canHitEntity(Entity target) {
        return target.isAlive() && !(target instanceof ItemEntity);
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            ServerLevel serverLevel;
            ItemStack item;
            Vec3 currentPosition = this.position();
            double speed = currentPosition.distanceTo(this.lastPosition);
            this.lastPosition = currentPosition;
            if ((this.inGround || speed < 1.0E-4) && !this.isNoPhysics() && (Integer)this.getEntityData().get(BOUNCE_COUNT) > 0) {
                if (((Boolean)this.getEntityData().get(SHOULD_DROP)).booleanValue() && !(item = this.getCarriedItem()).isEmpty()) {
                    serverLevel = (ServerLevel)this.level();
                    serverLevel.addFreshEntity((Entity)new ItemEntity((Level)serverLevel, this.getX(), this.getY(), this.getZ(), item));
                }
                this.discard();
            }
            if (this.tickCount > 300) {
                if (((Boolean)this.entityData.get(SHOULD_DROP)).booleanValue()) {
                    item = this.getCarriedItem();
                    serverLevel = (ServerLevel)this.level();
                    serverLevel.addFreshEntity((Entity)new ItemEntity((Level)serverLevel, this.getX(), this.getY(), this.getZ(), item));
                }
                this.discard();
            }
        }
    }

    public float getPickRadius() {
        return 0.5f;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putByte("inBlockState", (byte)0);
        compound.putByte("pickup", (byte)0);
        compound.putDouble("damage", 0.0);
        compound.putBoolean("crit", false);
        compound.putByte("PierceLevel", (byte)0);
        compound.putString("SoundEvent", "minecraft:entity.arrow.hit");
        compound.putBoolean("ShotFromCrossbow", false);
        ItemStack carriedItem = this.getCarriedItem();
        if (!carriedItem.isEmpty()) {
            compound.put("CarriedItem", carriedItem.save((HolderLookup.Provider)this.registryAccess()));
        }
        compound.putInt("BounceCount", ((Integer)this.getEntityData().get(BOUNCE_COUNT)).intValue());
        compound.putInt("MaxBounce", ((Integer)this.getEntityData().get(MAX_BOUNCE)).intValue());
        compound.putInt("Damage", ((Integer)this.getEntityData().get(DAMAGE)).intValue());
        compound.putBoolean("ShouldDrop", ((Boolean)this.getEntityData().get(SHOULD_DROP)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("CarriedItem", 10)) {
            CompoundTag itemTag = compound.getCompound("CarriedItem");
            ItemStack carriedItem = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)itemTag);
            this.setCarriedItem(carriedItem);
        }
        if (compound.contains("BounceCount")) {
            this.getEntityData().set(BOUNCE_COUNT, (Object)compound.getInt("BounceCount"));
        }
        if (compound.contains("MaxBounce")) {
            this.getEntityData().set(MAX_BOUNCE, (Object)compound.getInt("MaxBounce"));
        }
        if (compound.contains("Damage")) {
            this.getEntityData().set(DAMAGE, (Object)compound.getInt("Damage"));
        }
        if (compound.contains("ShouldDrop")) {
            this.getEntityData().set(SHOULD_DROP, (Object)compound.getBoolean("ShouldDrop"));
        }
    }

    protected ItemStack getPickupItem() {
        ItemStack carried = this.getCarriedItem();
        return carried.isEmpty() ? ItemStack.EMPTY : carried;
    }
}

