/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.misguided;

import com.mc3699.codmod.entity.misguided.EffectAndDespawnGoal;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.damagesource.DamageContainer;

public class MisguidedEntity
extends PathfinderMob {
    private static final int DESPAWN_TIME = 3600;
    private Mode currentMode;
    private int despawnTimer;

    public MisguidedEntity(EntityType<MisguidedEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 22.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    public Mode getMode() {
        return this.currentMode;
    }

    public void setMode(Mode mode) {
        this.currentMode = mode;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new EffectAndDespawnGoal(this));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getY() < 60.0) {
            this.setMode(Mode.AGGRESSIVE);
            this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        }
    }

    public void tick() {
        super.tick();
        if (this.currentMode == Mode.PASSIVE) {
            --this.despawnTimer;
            if (this.despawnTimer <= 0) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void onDamageTaken(DamageContainer damageContainer) {
        Entity entity = damageContainer.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            this.currentMode = Mode.AGGRESSIVE;
            this.setTarget(target);
        }
        super.onDamageTaken(damageContainer);
    }

    public static enum Mode {
        PASSIVE,
        AGGRESSIVE;

    }
}

