/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.swarmCod;

import com.mc3699.codmod.client.EntityAnimations;
import com.mc3699.codmod.entity.swarmCod.SwarmCodEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public class SwarmCodEntityModel
extends HierarchicalModel<SwarmCodEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"swarm_cod"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftFin;
    private final ModelPart rightFin;
    private final ModelPart tailfin;
    private final ModelPart waist;

    public SwarmCodEntityModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.leftFin = this.body.getChild("leftFin");
        this.rightFin = this.body.getChild("rightFin");
        this.tailfin = this.body.getChild("tailfin");
        this.waist = this.body.getChild("waist");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -4.0f, 1.0f, 2.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(20, -6).addBox(0.0f, -5.0f, 0.0f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(22, -1).addBox(0.0f, 0.0f, 3.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-0.9992f, -2.0008f, -3.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(11, 0).addBox(-1.0f, -2.0f, -2.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition leftFin = body.addOrReplaceChild("leftFin", CubeListBuilder.create().texOffs(24, 4).addBox(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition rightFin = body.addOrReplaceChild("rightFin", CubeListBuilder.create().texOffs(24, 1).addBox(-2.0f, 0.0f, 0.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition tailfin = body.addOrReplaceChild("tailfin", CubeListBuilder.create().texOffs(20, 1).addBox(0.0f, -4.0f, 0.0f, 0.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)8.0f));
        PartDefinition waist = body.addOrReplaceChild("waist", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int i1, int i2) {
        this.body.render(poseStack, vertexConsumer, i, i1);
    }

    public ModelPart root() {
        return this.body;
    }

    public void setupAnim(SwarmCodEntity swarmCodEntity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.root().xRot = 0.0f;
        float animTime = animationProgress / 20.0f;
        this.animate(swarmCodEntity, EntityAnimations.SWARM_COD_WALK_ANIM, animTime, 1.0f);
    }

    private void animate(SwarmCodEntity entity, AnimationDefinition animation, float time, float scale) {
        KeyframeAnimations.animate((HierarchicalModel)this, (AnimationDefinition)animation, (long)((long)(time * 1000.0f)), (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f));
    }
}

