/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.trialTrader;

import com.mc3699.codmod.entity.trialTrader.FollowGarethGoal;
import com.mc3699.codmod.entity.trialTrader.RepairGoal;
import com.mc3699.codmod.entity.trialTrader.RepairTask;
import com.mc3699.codmod.entity.trialTrader.TrialTraderAttackGoal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TrialTraderEntity
extends PathfinderMob {
    private final List<RepairTask> repairTasks = new ArrayList<RepairTask>();

    public TrialTraderEntity(EntityType<TrialTraderEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    protected void registerGoals() {
        if (!this.level().isClientSide()) {
            this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
            this.goalSelector.addGoal(1, (Goal)new RepairGoal(this));
            this.goalSelector.addGoal(2, (Goal)new TrialTraderAttackGoal(this));
            this.goalSelector.addGoal(3, (Goal)new FollowGarethGoal(this));
        }
        super.registerGoals();
    }

    public void onAddedToLevel() {
        this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.HOSTILE);
    }

    public void addRepairTask(BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, Player player) {
        this.repairTasks.add(new RepairTask(pos, state, blockEntity, player));
    }

    public List<RepairTask> getRepairTasks() {
        return this.repairTasks;
    }

    public void tick() {
        Level level;
        if (this.tickCount % 20 == 0 && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
        }
        super.tick();
    }
}

