/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.entity.trialTrader;

import com.mc3699.codmod.entity.trialTrader.TrialTraderEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="codmod", bus=EventBusSubscriber.Bus.GAME)
public class TrialTraderEvents {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            BlockState brokenBlock = event.getState();
            if (brokenBlock.is(Tags.Blocks.STORAGE_BLOCKS_COPPER) || brokenBlock.is(Blocks.TRIAL_SPAWNER) || brokenBlock.is(Blocks.VAULT)) {
                BlockPos breakPos = event.getPos();
                BlockEntity blockEntity = event.getLevel().getBlockEntity(breakPos);
                List trialTraders = serverLevel.getEntitiesOfClass(TrialTraderEntity.class, new AABB(breakPos).inflate(32.0));
                TrialTraderEntity closest = null;
                double minDist = Double.MAX_VALUE;
                for (TrialTraderEntity entity : trialTraders) {
                    double dist = entity.distanceToSqr(breakPos.getX(), breakPos.getY(), breakPos.getZ());
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    closest = entity;
                }
                if (closest != null) {
                    closest.addRepairTask(breakPos, brokenBlock, blockEntity, event.getPlayer());
                }
            }
        }
    }
}

