/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.handlers;

import com.mc3699.codmod.block.backrooms.CeilingLightBlock;
import com.mc3699.codmod.registry.CodArmor;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="codmod", bus=EventBusSubscriber.Bus.GAME)
public class BackroomsEvents {
    public static final ResourceKey<Level> BACKROOMS_DIM = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"backrooms"));
    public static final ResourceKey<Level> CITY_DIM = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"city"));
    private static Random random = new Random();

    @SubscribeEvent
    public static void backroomsEntryListener(LivingDamageEvent.Pre event) {
        LivingEntity entity;
        Level level;
        if (event.getSource().is(DamageTypes.IN_WALL) && (level = (entity = event.getEntity()).level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (random.nextInt(0, 12) == 2 && (entity.getInBlockState().equals(Blocks.SAND.defaultBlockState()) || entity.getInBlockState().equals(Blocks.GRAVEL.defaultBlockState()))) {
                event.getEntity().teleportTo(Objects.requireNonNull(serverLevel.getServer().getLevel(BACKROOMS_DIM)), entity.getX(), 3.0, entity.getZ(), RelativeMovement.ALL, entity.getYRot(), entity.getXRot());
                event.setNewDamage(0.0f);
            }
        }
    }

    public static void flicker(ServerLevel serverLevel, BlockPos center, int radius, float chance) {
        Random random = new Random();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    mutablePos.set(center.getX() + x, center.getY() + y, center.getZ() + z);
                    BlockState state = serverLevel.getBlockState((BlockPos)mutablePos);
                    if (!(state.getBlock() instanceof CeilingLightBlock) || !(random.nextFloat() < chance)) continue;
                    boolean lightEnabled = (Boolean)state.getValue((Property)CeilingLightBlock.ENABLED);
                    serverLevel.setBlock((BlockPos)mutablePos, (BlockState)state.setValue((Property)CeilingLightBlock.ENABLED, (Comparable)Boolean.valueOf(!lightEnabled)), 3);
                }
            }
        }
    }

    @SubscribeEvent
    public static void backroomsLivingTick(EntityTickEvent.Post event) {
        Level level;
        if (event.getEntity().level().dimension().equals(BACKROOMS_DIM) && (level = event.getEntity().level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = event.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                CompoundTag entityData = livingEntity.getPersistentData();
                AtomicBoolean suitValid = new AtomicBoolean(true);
                Iterable armorSlots = livingEntity.getArmorSlots();
                armorSlots.forEach(stack -> {
                    ArmorItem armorItem;
                    Item patt0$temp;
                    if (stack.isEmpty() || !((patt0$temp = stack.getItem()) instanceof ArmorItem) || !(armorItem = (ArmorItem)patt0$temp).getMaterial().equals((Object)Holder.direct((Object)CodArmor.NBC_ARMOR_MATERIAL))) {
                        suitValid.set(false);
                    }
                });
                if (suitValid.get()) {
                    entityData.putInt("br_sickness", 0);
                }
                int sickLevel = entityData.getInt("br_sickness");
                if (entityData.contains("br_sickness") && !suitValid.get()) {
                    entityData.putInt("br_sickness", sickLevel + 1);
                } else {
                    entityData.putInt("br_sickness", 0);
                }
            }
        }
    }
}

