/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.handlers;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="codmod")
public class CodScheduler {
    private static final List<ScheduledTask> active = new LinkedList<ScheduledTask>();
    private static final List<ScheduledTask> pending = new LinkedList<ScheduledTask>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(int delayTicks, Runnable action) {
        List<ScheduledTask> list = pending;
        synchronized (list) {
            pending.add(new ScheduledTask(delayTicks, action));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Post event) {
        List<ScheduledTask> list = pending;
        synchronized (list) {
            if (!pending.isEmpty()) {
                active.addAll(pending);
                pending.clear();
            }
        }
        Iterator<ScheduledTask> it = active.iterator();
        while (it.hasNext()) {
            ScheduledTask t = it.next();
            --t.ticks;
            if (t.ticks > 0) continue;
            try {
                t.action.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
            it.remove();
        }
    }

    private static class ScheduledTask {
        int ticks;
        Runnable action;

        ScheduledTask(int ticks, Runnable action) {
            this.ticks = ScheduledTask.delayToPositive(ScheduledTask.delayTicks(ticks));
            this.action = action;
        }

        private static int delayTicks(int t) {
            return Math.max(t, 0);
        }

        private static int delayToPositive(int t) {
            return t == 0 ? 1 : t;
        }
    }
}

