/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.handlers;

import com.mc3699.codmod.network.CodVariables;
import java.util.Comparator;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class NullFangCallbacks {
    private static final float PULL_FORCE_X = 0.025f;
    private static final float PULL_FORCE_Y = 0.02f;
    private static final float GRAB_DAMAGE_RESISTANCE_TICKS = 100.0f;
    private static final float WITHER_DURATION_TICKS = 60.0f;
    private static final int HOOK_DETECTION_RANGE = 50;
    private static final float GRAB_DETECT_RANGE = 1.5f;
    private static final float ENTITY_YANK_SPEED = 1.5f;

    public static void onHitEntity(LevelAccessor world, double x, double y, double z, Entity hitEntity, Entity shooter) {
        if (hitEntity == null || shooter == null) {
            return;
        }
        NullFangCallbacks.setPlayerGrappling(shooter, false);
        if (hitEntity instanceof LivingEntity) {
            double dz;
            double dy;
            LivingEntity living = (LivingEntity)hitEntity;
            double dx = shooter.getX() - living.getX();
            double distance = Math.sqrt(dx * dx + (dy = shooter.getY() - living.getY()) * dy + (dz = shooter.getZ() - living.getZ()) * dz);
            if (distance > 0.0) {
                dx = dx / distance * 1.5;
                dy = dy / distance * 1.5;
                dz = dz / distance * 1.5;
                double antiThing = Math.max(0.2, distance / 10.0 * 0.5);
                dx += dx / 1.5 * antiThing;
                dy += dy / 1.5 * antiThing;
                dz += dz / 1.5 * antiThing;
            }
            Vec3 motion = new Vec3(dx, dy += 0.5, dz);
            living.setDeltaMovement(motion);
        }
        NullFangCallbacks.playHitSound(world, x, y, z, "codmod:nullfanghit", 0.55f, 1.15f);
    }

    public static void onHitBlock(LevelAccessor world, BlockPos blockPos, Entity shooter) {
        double z;
        double y;
        if (shooter == null || !(shooter instanceof Player)) {
            return;
        }
        Player player = (Player)shooter;
        double x = blockPos.getX();
        if (player.distanceToSqr(x, y = (double)blockPos.getY(), z = (double)blockPos.getZ()) > 2500.0) {
            return;
        }
        if (!player.isShiftKeyDown()) {
            NullFangCallbacks.setHookPosition((Entity)player, x, y, z);
            NullFangCallbacks.setPlayerGrappling((Entity)player, true);
        }
        NullFangCallbacks.playHitSound(world, x, y, z, "codmod:nullfangclang", 0.45f, 1.0f);
    }

    private static void applyGrapplePull(LivingEntity player) {
        double hx = NullFangCallbacks.getHookX((Entity)player);
        double hy = NullFangCallbacks.getHookY((Entity)player);
        double hz = NullFangCallbacks.getHookZ((Entity)player);
        double dx = hx - player.getX();
        double dy = hy - player.getY();
        double dz = hz - player.getZ();
        player.push(dx * (double)0.025f, dy * (double)0.02f, dz * (double)0.025f);
        if (player.distanceToSqr(hx, hy, hz) < 2.25) {
            NullFangCallbacks.setPlayerGrappling((Entity)player, false);
        }
    }

    public static void onMeleeHit(LevelAccessor world, double x, double y, double z, Entity hitEntity, Entity attacker) {
        LivingEntity living;
        if (hitEntity == null || attacker == null) {
            return;
        }
        NullFangCallbacks.playHitSound(world, x, y, z, "codmod:nullfanghit", 1.0f, 1.0f);
        if (hitEntity instanceof LivingEntity && !(living = (LivingEntity)hitEntity).level().isClientSide()) {
            living.addEffect(new MobEffectInstance(MobEffects.WITHER, 60, 1, true, true));
        }
        if (hitEntity instanceof LivingEntity) {
            living = (LivingEntity)hitEntity;
            living.setSprinting(false);
            living.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(attacker.getX(), attacker.getY() + 1.0, attacker.getZ()));
        }
        if (hitEntity instanceof LivingEntity && (living = (LivingEntity)hitEntity).getHealth() <= 0.0f) {
            NullFangCallbacks.playHitSound(world, x, y, z, "codmod:nullfanghit", 0.6f, 0.75f);
        }
    }

    public static void onRangedShot(LevelAccessor world, double x, double y, double z, Entity shooter) {
        LivingEntity living;
        if (shooter == null) {
            return;
        }
        if (shooter instanceof LivingEntity && !(living = (LivingEntity)shooter).level().isClientSide()) {
            living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 0, false, false));
        }
        NullFangCallbacks.setPlayerGrappling(shooter, false);
        NullFangCallbacks.playHitSound(world, x, y, z, "codmod:nullfangthrow", 0.6f, 1.0f);
    }

    public static void onInventoryTick(Entity entity) {
        if (entity != null && entity.isShiftKeyDown()) {
            NullFangCallbacks.setPlayerGrappling(entity, false);
        }
    }

    private static void playHitSound(LevelAccessor world, double x, double y, double z, String soundId, float volume, float pitch) {
        Level level;
        if (world instanceof Level && !(level = (Level)world).isClientSide()) {
            level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)soundId)), SoundSource.PLAYERS, volume, pitch);
        } else if (world instanceof Level) {
            Level level2 = (Level)world;
            level2.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)soundId)), SoundSource.PLAYERS, volume, pitch, false);
        }
    }

    private static Player findNearestPlayer(LevelAccessor world, double x, double y, double z, double range) {
        return world.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)range, (double)range, (double)range)).stream().min(Comparator.comparingDouble(p -> p.distanceToSqr(x, y, z))).orElse(null);
    }

    public static void setPlayerGrappling(Entity entity, boolean grappling) {
        CodVariables.PlayerVariables vars = (CodVariables.PlayerVariables)entity.getData(CodVariables.PLAYER_VARIABLES);
        vars.isGrappling = grappling;
        vars.syncPlayerVariables(entity);
    }

    public static boolean isPlayerGrappling(Entity entity) {
        return ((CodVariables.PlayerVariables)entity.getData(CodVariables.PLAYER_VARIABLES)).isGrappling;
    }

    private static void setHookPosition(Entity entity, double x, double y, double z) {
        CodVariables.PlayerVariables vars = (CodVariables.PlayerVariables)entity.getData(CodVariables.PLAYER_VARIABLES);
        vars.hookx = x;
        vars.hooky = y;
        vars.hookz = z;
        vars.syncPlayerVariables(entity);
    }

    private static double getHookX(Entity entity) {
        return ((CodVariables.PlayerVariables)entity.getData(CodVariables.PLAYER_VARIABLES)).hookx;
    }

    private static double getHookY(Entity entity) {
        return ((CodVariables.PlayerVariables)entity.getData(CodVariables.PLAYER_VARIABLES)).hooky;
    }

    private static double getHookZ(Entity entity) {
        return ((CodVariables.PlayerVariables)entity.getData(CodVariables.PLAYER_VARIABLES)).hookz;
    }

    @EventBusSubscriber
    public static class GrapplingTickHandler {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Post event) {
            Player player = event.getEntity();
            if (NullFangCallbacks.isPlayerGrappling((Entity)player)) {
                NullFangCallbacks.applyGrapplePull((LivingEntity)player);
            }
        }
    }
}

