/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import dev.wendigodrip.thebrokenscript.api.entity.base.BaseCircuitEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class CircuitsBaneItem
extends SwordItem {
    UUID ancientUUID = UUID.fromString("743e3214-5958-4076-9876-a05337a84749");

    public CircuitsBaneItem(Item.Properties properties) {
        super((Tier)Tiers.NETHERITE, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"Made for ThatAncient2").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.literal((String)"Texture by ThatAncient2").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        if (entity instanceof Player && ((player = (Player)entity).hasPermissions(2) || player.getUUID().equals(this.ancientUUID)) && entity.tickCount % 10 == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AABB circuitSearch = entity.getBoundingBox().inflate(8.0);
            List circuits = serverLevel.getEntitiesOfClass(BaseCircuitEntity.class, circuitSearch);
            if (!circuits.isEmpty()) {
                if (isSelected) {
                    circuits.forEach(circuitEntity -> circuitEntity.setNoAi(true));
                }
                stack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            } else {
                stack.remove(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
            }
        }
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (entity instanceof BaseCircuitEntity) {
            BaseCircuitEntity circuitEntity = (BaseCircuitEntity)entity;
            circuitEntity.remove(Entity.RemovalReason.KILLED);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }
}

