/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class CleaverBladeItem
extends SwordItem {
    private static final WeakHashMap<UUID, Boolean> LAST_BOOST = new WeakHashMap();
    private static final WeakHashMap<UUID, Float> LAST_HEALTH = new WeakHashMap();
    private static final WeakHashMap<UUID, Integer> CRIT_HEAL_TIMER = new WeakHashMap();
    private static final WeakHashMap<UUID, Integer> CRIT_COOLDOWN = new WeakHashMap();
    private static final int CRIT_HEAL_DURATION = 40;
    private static final float TOTAL_HEAL = 4.0f;
    private static final int HEAL_COOLDOWN_TICKS = 80;
    private static final double SWEEP_RADIUS = 2.0;
    private static final double PLAYER_MAX_DISTANCE = 4.5;

    public CleaverBladeItem(Item.Properties properties) {
        super((Tier)Tiers.NETHERITE, properties.attributes(SwordItem.createAttributes((Tier)Tiers.NETHERITE, (float)7.0f, (float)-3.3f)));
    }

    public int getEnchantmentValue() {
        return 24;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (level.isClientSide()) {
            return;
        }
        boolean holding = player.getMainHandItem() == stack;
        int timer = CRIT_HEAL_TIMER.getOrDefault(player.getUUID(), 0);
        int cooldown = CRIT_COOLDOWN.getOrDefault(player.getUUID(), 0);
        if (cooldown > 0) {
            CRIT_COOLDOWN.put(player.getUUID(), cooldown - 1);
        }
        if (timer > 0) {
            float healPerTick = 0.1f;
            player.setHealth(Math.min(player.getHealth() + healPerTick, player.getMaxHealth()));
            if (--timer <= 0) {
                CRIT_HEAL_TIMER.remove(player.getUUID());
            } else {
                CRIT_HEAL_TIMER.put(player.getUUID(), timer);
            }
        }
        if (holding) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 10, 2, true, false));
        }
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.SHARPNESS) || enchantment.is(Enchantments.MENDING) || enchantment.is(Enchantments.BREACH) || enchantment.is(Enchantments.FIRE_ASPECT) || enchantment.is(Enchantments.SWEEPING_EDGE) || enchantment.is(Enchantments.UNBREAKING);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).level().isClientSide()) {
            boolean didHit = player.getPersistentData().getBoolean("cleaver_hit");
            if (!didHit) {
                float drain = 2.0f;
                player.causeFoodExhaustion(drain);
            }
            player.getPersistentData().putBoolean("cleaver_hit", false);
        }
        return false;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            player.getPersistentData().putBoolean("cleaver_hit", true);
            boolean fullyCharged = player.getAttackStrengthScale(0.5f) > 0.9f;
            boolean isFalling = player.fallDistance > 0.0f;
            boolean canCrit = !player.onGround() && !player.isInWater() && !player.isSprinting() && !player.hasEffect(MobEffects.BLINDNESS);
            boolean isCrit = fullyCharged && isFalling && canCrit;
            int cooldown = CRIT_COOLDOWN.getOrDefault(player.getUUID(), 0);
            if (isCrit && cooldown <= 0) {
                CRIT_HEAL_TIMER.put(player.getUUID(), 40);
                CRIT_COOLDOWN.put(player.getUUID(), 80);
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ANVIL_PLACE, SoundSource.PLAYERS, 0.8f, 0.5f);
                Level level = player.level();
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    server.sendParticles((ParticleOptions)ParticleTypes.CRIT, target.getX(), target.getY() + (double)target.getBbHeight() * 0.5, target.getZ(), 10, 0.1, 0.1, 0.1, 0.01);
                    server.sendParticles((ParticleOptions)ParticleTypes.POOF, target.getX(), target.getY() + (double)target.getBbHeight() * 0.5, target.getZ(), 6, 0.2, 0.2, 0.2, 0.04);
                }
            }
            player.sweepAttack();
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 1.0f, 1.0f);
            double dx = (double)(-Mth.sin((float)(player.getYRot() * (float)Math.PI / 180.0f))) * 1.25;
            double dz = (double)Mth.cos((float)(player.getYRot() * (float)Math.PI / 180.0f)) * 1.25;
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, player.getX() + dx, player.getY(0.5), player.getZ() + dz, 0, 0.0, 0.0, 0.0, 1.0);
            }
            float sweepDamage = (float)(1.0 + player.getAttributeValue(Attributes.ATTACK_DAMAGE) * 0.5);
            for (LivingEntity aoe : player.level().getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate(2.0), e -> e != player && e != target && (double)player.distanceTo((Entity)e) < 4.5)) {
                aoe.hurt(player.damageSources().playerAttack(player), sweepDamage);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)"Your heart, your weapon"));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

