/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CodKnifeItem
extends SwordItem {
    public CodKnifeItem(Item.Properties properties) {
        super((Tier)Tiers.NETHERITE, properties.attributes(SwordItem.createAttributes((Tier)Tiers.NETHERITE, (float)1.7f, (float)-2.4f)));
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.postHurtEnemy(stack, target, attacker);
        Level level = attacker.level();
        if (!level.isClientSide()) {
            for (int i = 0; i < 5; ++i) {
                Cod entity = new Cod(EntityType.COD, level);
                entity.setPos(target.getX(), target.getY(), target.getZ());
                level.addFreshEntity((Entity)entity);
                Random rand = new Random();
                Vec3 motion = target.getDeltaMovement().add((double)rand.nextFloat(1.0f), (double)rand.nextFloat(1.0f), (double)rand.nextFloat(1.0f));
                entity.setDeltaMovement(motion);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            for (int i = 0; i < 5; ++i) {
                Cod entity = new Cod(EntityType.COD, level);
                entity.setPos(player.getX(), player.getY(), player.getZ());
                level.addFreshEntity((Entity)entity);
                Random rand = new Random();
                Vec3 motion = player.getDeltaMovement().add((double)rand.nextFloat(1.0f), (double)rand.nextFloat(1.0f), (double)rand.nextFloat(1.0f));
                entity.setDeltaMovement(motion);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"The sharpest fish you'll ever hold."));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

