/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DiscordFruitItem
extends Item {
    Random random = new Random();

    public DiscordFruitItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (!level.isClientSide() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int duration = 200 + this.random.nextInt(1600);
            int strength = this.random.nextInt(2);
            this.giveRandomEffect(player, duration, strength);
            player.getCooldowns().addCooldown((Item)this, 180);
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    private void giveRandomEffect(Player player, int duration, int strength) {
        int STRENGTH = strength;
        int DURATION = duration;
        Holder[] possibleEffects = new Holder[]{MobEffects.BAD_OMEN, MobEffects.JUMP, MobEffects.GLOWING, MobEffects.WIND_CHARGED, MobEffects.LEVITATION, MobEffects.REGENERATION, MobEffects.NIGHT_VISION, MobEffects.CONFUSION, MobEffects.SLOW_FALLING};
        Holder randomEffect = possibleEffects[player.getRandom().nextInt(possibleEffects.length)];
        if (randomEffect == MobEffects.BAD_OMEN) {
            duration = 12000;
            strength = 1 + this.random.nextInt(5);
            player.addEffect(new MobEffectInstance(randomEffect, duration, strength));
        } else {
            player.addEffect(new MobEffectInstance(randomEffect, duration, strength));
        }
    }
}

