/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import foundry.veil.api.client.render.light.AreaLight;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;

public class MiningHeadgearItem
extends Item {
    private AreaLight light;

    public MiningHeadgearItem(Item.Properties properties) {
        super(properties);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return armorType.getIndex() == EquipmentSlot.HEAD.getIndex();
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return ItemAttributeModifiers.builder().add(Attributes.BLOCK_BREAK_SPEED, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"mining_gear_bs"), 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HEAD).add(Attributes.MINING_EFFICIENCY, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"mining_gear_me"), 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HEAD).build();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (slotId == EquipmentSlot.HEAD.getIndex() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 10, 1, true, false, false));
        }
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }
}

