/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import com.mc3699.codmod.entity.NullFangHookEntity;
import com.mc3699.codmod.handlers.NullFangCallbacks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class NullFangItem
extends Item {
    private static final int ATTACK_DAMAGE = 9;
    private static final double ATTACK_SPEED_MODIFIER = -2.4;
    private static final int MAX_STACK_SIZE = 1;
    private static final int DRAW_TIME_TICKS = 60;
    private static final float MIN_DRAW_POWER = 0.1f;

    public NullFangItem(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.EPIC).attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 9.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()).component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 60;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"A magenta-swirled harpoon-like growth. Venemous fang, seething with corruption.").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.literal((String)"Allows the user to grapple enemies as well as surfaces. (Sneak to unstuck yourself)\n").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.literal((String)"Made for Pinky - Initally Made by BigManRake - Fixed and UnMcreatored by Eyae").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player.getAbilities().instabuild || this.hasAmmo(player)) {
            player.startUsingItem(hand);
            return InteractionResultHolder.success((Object)itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity hitEntity, LivingEntity attacker) {
        boolean result = super.hurtEnemy(itemstack, hitEntity, attacker);
        NullFangCallbacks.onMeleeHit((LevelAccessor)hitEntity.level(), hitEntity.getX(), hitEntity.getY(), hitEntity.getZ(), (Entity)hitEntity, (Entity)attacker);
        return result;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (entity instanceof Player) {
            boolean isInHand;
            Player player = (Player)entity;
            ItemStack mainHand = player.getMainHandItem();
            ItemStack offHand = player.getOffhandItem();
            boolean bl = isInHand = mainHand == itemstack || offHand == itemstack;
            if (!isInHand && NullFangCallbacks.isPlayerGrappling(entity)) {
                NullFangCallbacks.setPlayerGrappling(entity, false);
            }
        }
        NullFangCallbacks.onInventoryTick(entity);
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int chargeTime) {
        if (world.isClientSide() || !(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        float drawPower = BowItem.getPowerForTime((int)(60 - chargeTime));
        if (drawPower < 0.1f) {
            return;
        }
        ItemStack ammo = this.findAmmo((Player)player);
        if (!player.getAbilities().instabuild && ammo.isEmpty()) {
            return;
        }
        NullFangHookEntity hook = NullFangHookEntity.shoot(world, entity, world.getRandom(), drawPower);
        if (player.getAbilities().instabuild) {
            hook.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        } else {
            this.consumeAmmo(ammo, world, player);
        }
        NullFangCallbacks.onRangedShot((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity);
    }

    private ItemStack findAmmo(Player player) {
        return new ItemStack((ItemLike)NullFangHookEntity.PROJECTILE_ITEM.getItem());
    }

    private boolean hasAmmo(Player player) {
        return !this.findAmmo(player).isEmpty();
    }

    private void consumeAmmo(ItemStack ammo, Level world, ServerPlayer player) {
        if (ammo.isDamageableItem()) {
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                ammo.hurtAndBreak(1, serverLevel, player, stack -> {});
            }
        } else {
            ammo.shrink(1);
        }
    }
}

