/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import com.mc3699.codmod.block.oxygenDistributor.OxygenDistributorBlock;
import com.mc3699.codmod.dimension.DimensionKeys;
import com.mc3699.codmod.registry.CodBlocks;
import com.mc3699.codmod.registry.CodComponents;
import com.mc3699.codmod.registry.CodItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class OxygenTankItem
extends Item {
    public static final int MAX_OXYGEN = 1000;

    public OxygenTankItem(Item.Properties properties) {
        super(properties);
    }

    public int getOxygen(ItemStack stack) {
        return (Integer)stack.getOrDefault(CodComponents.OXYGEN, (Object)0);
    }

    public void setOxygen(ItemStack stack, int value) {
        stack.set(CodComponents.OXYGEN, (Object)Math.min(value, 1000));
    }

    public boolean consumeOxygen(ItemStack stack, int amount) {
        int current = this.getOxygen(stack);
        if (current >= amount) {
            this.setOxygen(stack, current - amount);
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)("Oxygen: " + this.getOxygen(stack) + "ml")).withStyle(ChatFormatting.AQUA));
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        int oxygen = this.getOxygen(stack);
        return Math.round(13.0f * (float)oxygen / 1000.0f);
    }

    public int getBarColor(ItemStack stack) {
        float f = (float)this.getOxygen(stack) / 1000.0f;
        int red = 0xFF0000;
        int blue = 65535;
        int r = (int)((float)(red >> 16 & 0xFF) * (1.0f - f) + (float)(blue >> 16 & 0xFF) * f);
        int g = (int)((float)(red >> 8 & 0xFF) * (1.0f - f) + (float)(blue >> 8 & 0xFF) * f);
        int b = (int)((float)(red & 0xFF) * (1.0f - f) + (float)(blue & 0xFF) * f);
        return r << 16 | g << 8 | b;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack;
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).dimension() != DimensionKeys.ENTROPY && (stack = player.getItemInHand(usedHand)).is(CodItems.OXYGEN_TANK)) {
            stack.set(CodComponents.OXYGEN, (Object)1000);
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(usedHand));
    }

    public InteractionResult useOn(UseOnContext context) {
        ServerLevel serverLevel;
        Level level = context.getLevel();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getBlockState(context.getClickedPos()).equals(((OxygenDistributorBlock)((Object)CodBlocks.OXYGEN_DISTRIBUTOR.get())).defaultBlockState())) {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            ItemStack stack = player.getItemInHand(context.getHand());
            stack.set(CodComponents.OXYGEN, (Object)1000);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

