/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import com.mc3699.codmod.registry.CodItems;
import com.mc3699.codmod.registry.CodMobEffects;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class RatBladeItem
extends SwordItem {
    private static final Tier RATBLADE = new Tier(){

        public int getUses() {
            return 700;
        }

        public float getSpeed() {
            return 12.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public int getEnchantmentValue() {
            return 12;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CodItems.CHEESE.get())});
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_IRON_TOOL;
        }
    };

    public RatBladeItem(Item.Properties properties) {
        super(RATBLADE, properties.attributes(RatBladeItem.createAttributes((Tier)RATBLADE, (float)7.25f, (float)-1.4f)));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.addEffect(new MobEffectInstance(CodMobEffects.BLEEDING, 80, 0));
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (!player.level().isClientSide) {
                CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                CompoundTag tag = customData.copyTag();
                int hitCount = tag.getInt("HitCount");
                if (++hitCount >= 6) {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200, 0, false, false));
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 200, 0, false, false));
                    hitCount = 0;
                }
                tag.putInt("HitCount", hitCount);
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"\u00a7e\u00a7lMade by Heaven"));
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        int hitCount = customData.copyTag().getInt("HitCount");
        tooltipComponents.add((Component)Component.literal((String)("\u00a77Hits: \u00a7f" + hitCount + "\u00a77/\u00a7f6 \u00a76(squeek)")));
        tooltipComponents.add((Component)Component.literal((String)"\u00a776 hits = \u00a7bSpeed \u00a7rand \u00a7cStrength \u00a77for 10s \u00a76(pip)"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.SHARPNESS) || enchantment.is(Enchantments.SMITE) || enchantment.is(Enchantments.BANE_OF_ARTHROPODS) || enchantment.is(Enchantments.KNOCKBACK) || enchantment.is(Enchantments.FIRE_ASPECT) || enchantment.is(Enchantments.LOOTING) || enchantment.is(Enchantments.SWEEPING_EDGE) || enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.MENDING) || enchantment.is(Enchantments.VANISHING_CURSE);
    }
}

