/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import com.mc3699.codmod.entity.itemProjectile.ItemProjectileEntity;
import com.mc3699.codmod.registry.CodEntities;
import com.mc3699.codmod.registry.CodItems;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ShrimpSniperItem
extends Item {
    public ShrimpSniperItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        player.startUsingItem(usedHand);
        return InteractionResultHolder.consume((Object)player.getItemInHand(usedHand));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 1000000;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        ItemProjectileEntity projectile = new ItemProjectileEntity((EntityType<? extends ItemProjectileEntity>)((EntityType)CodEntities.ITEM_PROJECTILE.get()), level, new ItemStack((ItemLike)CodItems.SHRIMP.get(), 1), 0, 100, true);
        Vec3 eyePos = livingEntity.getEyePosition();
        Vec3 lookVec = livingEntity.getViewVector(1.0f).normalize().scale(0.8);
        projectile.setPos(eyePos.x + lookVec.x, eyePos.y + lookVec.y, eyePos.z + lookVec.z);
        projectile.shootFromRotation((Entity)livingEntity, livingEntity.getXRot(), livingEntity.getYRot(), 1.0f, 5.0f, 0.0f);
        level.addFreshEntity((Entity)projectile);
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
    }
}

