/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TearsOfBloodItem
extends SwordItem {
    private static final int COOLDOWN_TICKS = 50;
    private static final double SLASH_RANGE = 4.0;
    private static final double SLASH_WIDTH = 2.5;
    private static final int WITHER_DURATION = 100;
    private static final int WITHER_AMPLIFIER = 1;

    public TearsOfBloodItem(Item.Properties properties) {
        super((Tier)Tiers.NETHERITE, properties.attributes(SwordItem.createAttributes((Tier)Tiers.NETHERITE, (int)4, (float)-2.0f)));
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 15;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        this.performSlashAttack(level, player);
        player.getCooldowns().addCooldown((Item)this, 50);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResultHolder.success((Object)itemStack);
    }

    private void performSlashAttack(Level level, Player player) {
        Vec3 lookVec = player.getLookAngle();
        Vec3 playerPos = player.position().add(0.0, (double)player.getEyeHeight() * 0.5, 0.0);
        Vec3 slashEnd = playerPos.add(lookVec.scale(4.0));
        AABB slashBox = new AABB(playerPos, slashEnd).inflate(2.5);
        List entities = level.getEntitiesOfClass(LivingEntity.class, slashBox, entity -> entity != player && entity.isAlive());
        for (LivingEntity target : entities) {
            double distance;
            Vec3 toTarget = target.position().subtract(playerPos).normalize();
            double dotProduct = lookVec.dot(toTarget);
            if (!(dotProduct > 0.3) || !((distance = playerPos.distanceTo(target.position())) <= 4.0)) continue;
            target.hurt(level.damageSources().playerAttack(player), 8.0f);
            target.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 1));
            Vec3 knockback = lookVec.scale(0.5);
            target.push(knockback.x, 0.2, knockback.z);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnSlashParticles(serverLevel, playerPos, lookVec);
        }
    }

    private void spawnSlashParticles(ServerLevel level, Vec3 startPos, Vec3 direction) {
        Vec3 rightVec = new Vec3(-direction.z, 0.0, direction.x).normalize();
        int particleCount = 25;
        for (int i = 0; i < particleCount; ++i) {
            double arcProgress = (double)i / (double)(particleCount - 1) - 0.5;
            double angle = arcProgress * Math.PI * 0.8;
            double distance = 3.0;
            Vec3 offset = direction.scale(Math.cos(angle) * distance).add(rightVec.scale(Math.sin(angle) * distance));
            Vec3 particlePos = startPos.add(offset);
            level.sendParticles((ParticleOptions)ParticleTypes.INSTANT_EFFECT, particlePos.x, particlePos.y, particlePos.z, 2, 0.1, 0.1, 0.1, 0.0);
        }
    }
}

