/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item.marksmanRevolver;

import com.mc3699.codmod.entity.MarksmanRevolverCoinEntity;
import com.mc3699.codmod.entity.itemProjectile.ItemProjectileEntity;
import com.mc3699.codmod.handlers.CodScheduler;
import com.mc3699.codmod.handlers.beamStuff.RenderBeamPayload;
import com.mc3699.codmod.registry.CodEntities;
import com.mc3699.codmod.registry.CodSounds;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class MarksmanRevolverItem
extends SwordItem {
    public MarksmanRevolverItem(Item.Properties properties) {
        super((Tier)Tiers.WOOD, properties);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        Player player;
        Level level;
        if (entity instanceof Player && (level = (player = (Player)entity).level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.fireRaycast(serverLevel, player);
            serverLevel.playSound(null, player.blockPosition(), (SoundEvent)CodSounds.SUPRESSED_GUNSHOT.value(), SoundSource.MASTER, 0.5f, 1.5f);
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        Vec3 look = player.getLookAngle().scale(2.0);
        Vec3 coinSpawnPos = new Vec3(look.x, -0.5, look.z);
        Level level2 = player.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            for (int i = 0; i < 1; ++i) {
                CodScheduler.schedule(i, () -> {
                    MarksmanRevolverCoinEntity coinEntity = new MarksmanRevolverCoinEntity((EntityType<? extends ItemProjectileEntity>)((EntityType)CodEntities.MARKSMAN_COIN_ENTITY.get()), (Level)serverLevel);
                    coinEntity.setPos(player.getEyePosition().add(coinSpawnPos));
                    Vec3 forwardImpulse = player.getLookAngle().scale(0.3);
                    Vec3 upwardImpulse = new Vec3(0.0, 0.6, 0.0);
                    Vec3 inheritedVelocity = player.getDeltaMovement();
                    coinEntity.setDeltaMovement(inheritedVelocity.add(forwardImpulse).add(upwardImpulse));
                    coinEntity.setOwner((Entity)player);
                    serverLevel.addFreshEntity((Entity)coinEntity);
                    serverLevel.playSound(null, player.blockPosition(), (SoundEvent)CodSounds.COIN.value(), SoundSource.MASTER, 1.0f, 1.0f);
                });
            }
        }
        return super.use(level, player, usedHand);
    }

    private void fireRaycast(ServerLevel serverLevel, Player player) {
        Vec3 finalHitPos;
        double maxRange = 250.0;
        Vec3 start = player.getEyePosition();
        Vec3 look = player.getLookAngle();
        Vec3 end = start.add(look.scale(maxRange));
        BlockHitResult blockHit = serverLevel.clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        AABB aabb = player.getBoundingBox().expandTowards(look.scale(maxRange)).inflate(1.0);
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)start, (Vec3)end, (AABB)aabb, e -> e != player, (double)(maxRange * maxRange));
        boolean hitEntity = false;
        if (entityHit != null) {
            double blockDist;
            double entityDist = entityHit.getLocation().distanceToSqr(start);
            if (entityDist < (blockDist = blockHit.getLocation().distanceToSqr(start))) {
                hitEntity = true;
                finalHitPos = entityHit.getLocation();
            } else {
                finalHitPos = blockHit.getLocation();
            }
        } else {
            finalHitPos = blockHit.getLocation();
        }
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new RenderBeamPayload(start.add(0.0, -0.25, 0.0), finalHitPos, 0.02f, 20, 0xFFFF00), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (hitEntity && entityHit != null) {
            Entity entity = entityHit.getEntity();
            if (entity instanceof MarksmanRevolverCoinEntity) {
                MarksmanRevolverCoinEntity coin = (MarksmanRevolverCoinEntity)entity;
                coin.hit(player);
            }
            entityHit.getEntity().hurt(serverLevel.damageSources().playerAttack(player), 10.0f);
        }
    }
}

