/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item.starstruckSpear;

import com.mc3699.codmod.network.CodVariables;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class StarstruckDash {
    public static void performDash(LivingEntity player, int charge) {
        CodVariables.PlayerVariables vars = (CodVariables.PlayerVariables)player.getData(CodVariables.PLAYER_VARIABLES);
        vars.isDashing = true;
        vars.dashTicksRemaining = 30;
        double dashSpeed = 0.0;
        if (charge >= 10 && charge < 20) {
            dashSpeed = 1.25;
        } else if (charge >= 20) {
            dashSpeed = 2.1;
        }
        Vec3 lookDirection = player.getLookAngle();
        Vec3 dashVelocity = lookDirection.scale(dashSpeed);
        dashVelocity = new Vec3(dashVelocity.x, dashVelocity.y * 0.75, dashVelocity.z);
        player.setDeltaMovement(dashVelocity);
        player.hurtMarked = true;
    }

    public static boolean isPlayerDashing(Entity entity) {
        return ((CodVariables.PlayerVariables)entity.getData(CodVariables.PLAYER_VARIABLES)).isDashing;
    }

    @EventBusSubscriber
    private static class PlayerTickHandler {
        private PlayerTickHandler() {
        }

        @SubscribeEvent
        private static void onPlayerTick(PlayerTickEvent.Post event) {
            Player player = event.getEntity();
            if (StarstruckDash.isPlayerDashing((Entity)player)) {
                CodVariables.PlayerVariables vars = (CodVariables.PlayerVariables)player.getData(CodVariables.PLAYER_VARIABLES);
                --vars.dashTicksRemaining;
                if (vars.dashTicksRemaining <= 0) {
                    vars.isDashing = false;
                } else {
                    AABB playerBox = player.getBoundingBox();
                    playerBox.inflate(2.0);
                    List collidingEntities = player.level().getEntities((Entity)player, playerBox);
                    for (Entity entity : collidingEntities) {
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity target = (LivingEntity)entity;
                        DamageSource dashDamage = player.damageSources().playerAttack(player);
                        target.hurt(dashDamage, 5.5f);
                    }
                }
            }
        }
    }
}

