/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.item.starstruckSpear;

import com.mc3699.codmod.item.starstruckSpear.StarstruckDash;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class StarstruckSpearItem
extends AxeItem {
    public StarstruckSpearItem(Item.Properties properties) {
        super((Tier)Tiers.NETHERITE, properties.attributes(AxeItem.createAttributes((Tier)Tiers.NETHERITE, (float)4.0f, (float)-2.9f)).durability(2250).rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"Reach for the stars!").withStyle(ChatFormatting.LIGHT_PURPLE));
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(Items.GOLD_INGOT);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.SHARPNESS) | enchantment.is(Enchantments.UNBREAKING) | enchantment.is(Enchantments.FIRE_ASPECT) | enchantment.is(Enchantments.LOOTING) | enchantment.is(Enchantments.KNOCKBACK) | enchantment.is(Enchantments.BREACH) | enchantment.is(Enchantments.SMITE) | enchantment.is(Enchantments.IMPALING) | enchantment.is(Enchantments.BANE_OF_ARTHROPODS);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        player.startUsingItem(usedHand);
        return InteractionResultHolder.consume((Object)player.getItemInHand(usedHand));
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (!level.isClientSide() && livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            int chargeTime = this.getUseDuration(stack, livingEntity) - timeCharged;
            StarstruckDash.performDash((LivingEntity)player, chargeTime);
            player.getCooldowns().addCooldown((Item)this, 60);
            return;
        }
        super.releaseUsing(stack, level, livingEntity, timeCharged);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_TRIDENT_ACTIONS.contains(itemAbility);
    }
}

