/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.network;

import com.mc3699.codmod.Codmod;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CodVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"codmod");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        Codmod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double hookx = 0.0;
        public double hooky = 0.0;
        public double hookz = 0.0;
        public boolean isGrappling = false;
        public boolean grabbed = false;
        public double grabx = 0.0;
        public double graby = 0.0;
        public double grabz = 0.0;
        public String godhasleftus = "\"\"";
        public String whereisgod = "\"\"";
        public boolean isDashing = false;
        public int dashTicksRemaining = 30;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("hookx", this.hookx);
            nbt.putDouble("hooky", this.hooky);
            nbt.putDouble("hookz", this.hookz);
            nbt.putBoolean("isGrappling", this.isGrappling);
            nbt.putBoolean("grabbed", this.grabbed);
            nbt.putDouble("grabx", this.grabx);
            nbt.putDouble("graby", this.graby);
            nbt.putDouble("grabz", this.grabz);
            nbt.putString("godhasleftus", this.godhasleftus);
            nbt.putString("whereisgod", this.whereisgod);
            nbt.putBoolean("isDashing", this.isDashing);
            nbt.putInt("dashTicksRemaining", this.dashTicksRemaining);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.hookx = nbt.getDouble("hookx");
            this.hooky = nbt.getDouble("hooky");
            this.hookz = nbt.getDouble("hookz");
            this.isGrappling = nbt.getBoolean("isGrappling");
            this.grabbed = nbt.getBoolean("grabbed");
            this.grabx = nbt.getDouble("grabx");
            this.graby = nbt.getDouble("graby");
            this.grabz = nbt.getDouble("grabz");
            this.godhasleftus = nbt.getString("godhasleftus");
            this.whereisgod = nbt.getString("whereisgod");
            this.isDashing = nbt.getBoolean("isDashing");
            this.dashTicksRemaining = nbt.getInt("dashTicksRemaining");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            if (!event.isWasDeath()) {
                clone.hookx = original.hookx;
                clone.hooky = original.hooky;
                clone.hookz = original.hookz;
                clone.isGrappling = original.isGrappling;
                clone.grabbed = original.grabbed;
                clone.grabx = original.grabx;
                clone.graby = original.graby;
                clone.grabz = original.grabz;
                clone.godhasleftus = original.godhasleftus;
                clone.whereisgod = original.whereisgod;
                clone.isDashing = original.isDashing;
                clone.dashTicksRemaining = original.dashTicksRemaining;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }
    }
}

