/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.network;

import com.mc3699.codmod.network.DisplayImagePayload;
import com.mc3699.codmod.network.ImageFileRequestPayload;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ImageRelayPayload(ImageFileRequestPayload payload, byte[] image) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"codmod", (String)"relay_image");
    public static final CustomPacketPayload.Type<ImageRelayPayload> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, ImageRelayPayload> CODEC = StreamCodec.of((buf, p) -> {
        ImageFileRequestPayload.CODEC.encode(buf, (Object)p.payload());
        buf.writeByteArray(p.image);
    }, buf -> {
        ImageFileRequestPayload inner = (ImageFileRequestPayload)ImageFileRequestPayload.CODEC.decode(buf);
        return new ImageRelayPayload(inner, buf.readByteArray());
    });

    public static void handle(ImageRelayPayload payload, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer sender = (ServerPlayer)ctx.player();
            MinecraftServer server = sender.server;
            ImageFileRequestPayload data = payload.payload();
            for (UUID uuid : data.players()) {
                ServerPlayer target = server.getPlayerList().getPlayer(uuid);
                if (target == null) continue;
                PacketDistributor.sendToPlayer((ServerPlayer)target, (CustomPacketPayload)new DisplayImagePayload(payload.image, data.x(), data.y(), data.scaleX(), data.scaleY(), data.duration()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

