/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.peripheral;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class EnvironmentScannerPeripheral
implements IPeripheral {
    private final ITurtleAccess access;

    public EnvironmentScannerPeripheral(ITurtleAccess access) {
        this.access = access;
    }

    @LuaFunction
    public final Map<Integer, Map<String, Object>> scanEntities(double radius) {
        HashMap<Integer, Map<String, Object>> result = new HashMap<Integer, Map<String, Object>>();
        AABB searchArea = new AABB(this.access.getPosition()).inflate(radius);
        BlockPos origin = this.access.getPosition();
        Level level = this.access.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List entities = serverLevel.getEntities((Entity)null, searchArea, entity -> true);
            int index = 1;
            for (Entity entity2 : entities) {
                HashMap<String, Object> entityData = new HashMap<String, Object>();
                entityData.put("type", entity2.getType().builtInRegistryHolder().key().location().toString());
                entityData.put("name", entity2.getName().getString());
                entityData.put("x", entity2.getX() - (double)origin.getX());
                entityData.put("y", entity2.getY() - (double)origin.getY());
                entityData.put("z", entity2.getZ() - (double)origin.getZ());
                entityData.put("uuid", entity2.getUUID().toString());
                result.put(index++, entityData);
            }
        }
        return result;
    }

    @LuaFunction
    public final Map<Integer, Map<String, Object>> scanBlocks(double radius) {
        HashMap<Integer, Map<String, Object>> result = new HashMap<Integer, Map<String, Object>>();
        AABB searchArea = new AABB(this.access.getPosition()).inflate(radius);
        BlockPos origin = this.access.getPosition();
        Level level = this.access.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int index = 1;
            for (BlockPos pos : BlockPos.betweenClosedStream((AABB)searchArea).toList()) {
                BlockState state = serverLevel.getBlockState(pos);
                HashMap<String, Object> blockData = new HashMap<String, Object>();
                blockData.put("type", state.getBlock().builtInRegistryHolder().key().location().toString());
                blockData.put("x", pos.getX() - origin.getX());
                blockData.put("y", pos.getY() - origin.getY());
                blockData.put("z", pos.getZ() - origin.getZ());
                result.put(index++, blockData);
            }
        }
        return result;
    }

    @LuaFunction
    public final String getDirection() {
        return this.access.getDirection().toString();
    }

    @LuaFunction
    public final Map<String, Integer> getPos() {
        BlockPos pos = this.access.getPosition();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("x", pos.getX());
        result.put("y", pos.getY());
        result.put("z", pos.getZ());
        return result;
    }

    public String getType() {
        return "environment_scanner";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return false;
    }
}

