/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.technology.foundation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class BaseCableBlockEntity
extends BlockEntity {
    private final IEnergyStorage energyStorage = new EnergyStorage(1000);
    private final int maxTransfer = 100;

    public BaseCableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public int getMaxTransfer() {
        return 100;
    }

    @Nullable
    public IEnergyStorage getEnergyCap(BlockEntity o, Direction direction) {
        return this.energyStorage;
    }

    public static <T extends BlockEntity> void transferTick(Level level, BlockPos pos, BlockState state, T t) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (!(t instanceof BaseCableBlockEntity)) {
            return;
        }
        BaseCableBlockEntity self = (BaseCableBlockEntity)t;
        for (Direction direction : Direction.values()) {
            int received;
            int extracted;
            int toSend;
            int otherEnergy;
            int selfEnergy;
            BlockPos neighborPos = pos.relative(direction);
            BlockEntity neighbor = level.getBlockEntity(neighborPos);
            if (!(neighbor instanceof BaseCableBlockEntity)) continue;
            BaseCableBlockEntity other = (BaseCableBlockEntity)neighbor;
            if (neighbor.isRemoved() || Math.abs((selfEnergy = self.energyStorage.getEnergyStored()) - (otherEnergy = other.energyStorage.getEnergyStored())) < 2) continue;
            if (selfEnergy > otherEnergy) {
                toSend = (selfEnergy - otherEnergy) / 2;
                extracted = self.energyStorage.extractEnergy(toSend, true);
                received = other.energyStorage.receiveEnergy(extracted, true);
                if (received <= 0) continue;
                self.energyStorage.extractEnergy(received, false);
                other.energyStorage.receiveEnergy(received, false);
                continue;
            }
            toSend = (otherEnergy - selfEnergy) / 2;
            extracted = other.energyStorage.extractEnergy(toSend, true);
            received = self.energyStorage.receiveEnergy(extracted, true);
            if (received <= 0) continue;
            other.energyStorage.extractEnergy(received, false);
            self.energyStorage.receiveEnergy(received, false);
        }
    }
}

