/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.technology.foundation;

import com.mc3699.codmod.technology.foundation.BaseCableBlockEntity;
import com.mc3699.codmod.technology.foundation.BaseMachineBlockEntity;
import com.mc3699.codmod.technology.foundation.IGeneratingMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class BaseGeneratingMachineBlockEntity
extends BaseMachineBlockEntity
implements IGeneratingMachine {
    public BaseGeneratingMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState, int maxEnergy, int slots) {
        super(type, pos, blockState, maxEnergy, slots);
    }

    public static <T extends BlockEntity> void energyExportTick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        for (Direction direction : Direction.values()) {
            int extractSimulated;
            BaseGeneratingMachineBlockEntity self = (BaseGeneratingMachineBlockEntity)t;
            BlockEntity neighbor = level.getBlockEntity(blockPos.relative(direction));
            if (neighbor == null) continue;
            IEnergyStorage target = null;
            if (neighbor instanceof BaseCableBlockEntity) {
                BaseCableBlockEntity neighborCable = (BaseCableBlockEntity)neighbor;
                target = neighborCable.getEnergyCap(neighbor, direction.getOpposite());
            } else if (neighbor instanceof BaseMachineBlockEntity) {
                BaseMachineBlockEntity machineBlockEntity = (BaseMachineBlockEntity)neighbor;
                target = machineBlockEntity.getEnergyCap(machineBlockEntity, direction.getOpposite());
            }
            if (target == null || !target.canReceive() || (extractSimulated = self.energyStorage.extractEnergy(1000, true)) <= 0) continue;
            int accepted = target.receiveEnergy(extractSimulated, false);
            self.energyStorage.extractEnergy(accepted, false);
        }
    }

    @Override
    public int getEnergyProduction() {
        return 0;
    }

    @Override
    public boolean canProduce() {
        return false;
    }
}

