/*
 * Decompiled with CFR 0.152.
 */
package com.mc3699.codmod.technology.foundation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.jarjar.nio.util.Lazy;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class BaseMachineBlockEntity
extends BlockEntity
implements IEnergyStorage {
    protected final EnergyStorage energyStorage;
    protected final ContainerData data;
    protected final ItemStackHandler itemStackHandler;
    private final Lazy<IItemHandler> itemHandlerLazy;

    public BaseMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState, int maxEnergy, int slots) {
        super(type, pos, blockState);
        this.energyStorage = new EnergyStorage(maxEnergy);
        this.data = new SimpleContainerData(16);
        this.itemStackHandler = new ItemStackHandler(slots){

            protected void onContentsChanged(int slot) {
                BaseMachineBlockEntity.this.setChanged();
            }
        };
        this.itemHandlerLazy = Lazy.of(() -> this.itemStackHandler);
    }

    public ContainerData getData() {
        return this.data;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("energy", this.energyStorage.serializeNBT(registries));
        tag.put("inventory", (Tag)this.itemStackHandler.serializeNBT(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.energyStorage.deserializeNBT(registries, (Tag)tag.getCompound("energy"));
        this.itemStackHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        this.data.set(0, this.energyStorage.getEnergyStored());
    }

    public int receiveEnergy(int i, boolean b) {
        return this.energyStorage.receiveEnergy(i, b);
    }

    public int extractEnergy(int i, boolean b) {
        return this.energyStorage.extractEnergy(i, b);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    @Nullable
    public IItemHandler getItemCap(BlockEntity o, Direction direction) {
        return this.itemStackHandler;
    }

    @Nullable
    public IEnergyStorage getEnergyCap(BlockEntity o, Direction direction) {
        return this.energyStorage;
    }
}

