/*
 * Decompiled with CFR 0.152.
 */
package de.awolfynight.simplevoicedistance.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ServerConfig {
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ConfigValues SERVER;

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        SERVER = new ConfigValues(builder);
        SERVER_SPEC = builder.build();
    }

    public static class ConfigValues {
        public final ForgeConfigSpec.DoubleValue whisperDistance;
        public final ForgeConfigSpec.DoubleValue normalDistance;
        public final ForgeConfigSpec.DoubleValue shoutDistance;
        public final ForgeConfigSpec.IntValue cooldownSeconds;

        public ConfigValues(ForgeConfigSpec.Builder builder) {
            builder.comment("Voice distance settings").push("voice_distance");
            this.whisperDistance = builder.comment("Distance for whisper mode").defineInRange("whisperDistance", 4.0, 1.0, 100.0);
            this.normalDistance = builder.comment("Distance for normal mode").defineInRange("normalDistance", 15.0, 1.0, 100.0);
            this.shoutDistance = builder.comment("Distance for shout mode").defineInRange("shoutDistance", 30.0, 1.0, 200.0);
            this.cooldownSeconds = builder.comment("Cooldown duration in seconds for cycling voice distance mode").defineInRange("cooldownSeconds", 1, 0, 60);
            builder.pop();
        }
    }
}

