/*
 * Decompiled with CFR 0.152.
 */
package de.awolfynight.simplevoicedistance.network;

import de.awolfynight.simplevoicedistance.voicemanager.VoiceDistanceData;
import de.awolfynight.simplevoicedistance.voicemanager.VoiceDistanceManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ChangeModePacket {
    private final VoiceDistanceManager.Mode mode;

    public ChangeModePacket(VoiceDistanceManager.Mode mode) {
        this.mode = mode;
    }

    public static ChangeModePacket decode(FriendlyByteBuf buf) {
        int ordinal = buf.readInt();
        VoiceDistanceManager.Mode[] modes = VoiceDistanceManager.Mode.values();
        if (ordinal < 0 || ordinal >= modes.length) {
            ordinal = VoiceDistanceManager.Mode.NORMAL.ordinal();
        }
        return new ChangeModePacket(modes[ordinal]);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.mode.ordinal());
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                VoiceDistanceManager.updateModeFromServer(this.mode);
            } else {
                ServerPlayer player = ctx.getSender();
                VoiceDistanceData.setMode(player.m_20148_(), this.mode);
            }
        });
        ctx.setPacketHandled(true);
    }
}

