/*
 * Decompiled with CFR 0.152.
 */
package de.awolfynight.simplevoicedistance.renderer;

import de.awolfynight.simplevoicedistance.config.ClientConfig;
import de.awolfynight.simplevoicedistance.keymapping.KeyBindings;
import de.awolfynight.simplevoicedistance.voicemanager.VoiceDistanceManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="simplevoicedistance", value={Dist.CLIENT})
public class VoiceHudRenderer {
    private static final ResourceLocation ICON = new ResourceLocation("simplevoicedistance", "textures/gui/distance_icon.png");

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91066_.f_92062_ || mc.f_91074_.m_5833_() || !KeyBindings.isHudEnabled()) {
            return;
        }
        GuiGraphics gui = event.getGuiGraphics();
        Font font = mc.f_91062_;
        float distance = VoiceDistanceManager.getCurrentMode().getDistance();
        String text = String.format("%.0fm", Float.valueOf(distance));
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        int hotbarX = width / 2 - 91;
        int hotbarY = height - 20;
        int baseX = hotbarX - 50 + (Integer)ClientConfig.CLIENT.hudOffsetX.get();
        int baseY = hotbarY + (Integer)ClientConfig.CLIENT.hudOffsetY.get();
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85841_(1.2f, 1.2f, 1.0f);
        int scaledX = (int)((double)baseX / 1.2);
        int scaledY = (int)((double)baseY / 1.2);
        gui.m_280163_(ICON, scaledX, scaledY, 0.0f, 0.0f, 20, 20, 20, 20);
        int textY = scaledY + 7;
        gui.m_280056_(font, text, scaledX + 16, textY, 0xFFFFFF, true);
        gui.m_280168_().m_85849_();
    }
}

