/*
 * Decompiled with CFR 0.152.
 */
package de.awolfynight.simplevoicedistance.voicemanager;

import de.awolfynight.simplevoicedistance.Simplevoicedistance;
import de.awolfynight.simplevoicedistance.config.ServerConfig;
import de.awolfynight.simplevoicedistance.network.ChangeModePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VoiceDistanceManager {
    private static Mode currentMode = Mode.NORMAL;
    private static int particleTimer = 0;
    private static final int PARTICLE_TICKS = 40;
    private static final int PARTICLE_COUNT = 40;
    private static final double PARTICLE_Y_OFFSET = 1.0;

    public static void cycleMode() {
        Mode[] values = Mode.values();
        int nextIndex = (currentMode.ordinal() + 1) % values.length;
        VoiceDistanceManager.setMode(values[nextIndex]);
    }

    public static void setMode(Mode newMode) {
        if (newMode != currentMode) {
            currentMode = newMode;
            VoiceDistanceManager.applyMode();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void applyMode() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        particleTimer = 40;
        Simplevoicedistance.CHANNEL.sendToServer((Object)new ChangeModePacket(currentMode));
    }

    public static void tickParticles() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || particleTimer-- <= 0) {
            return;
        }
        double radius = currentMode.getDistance();
        double y = mc.f_91074_.m_20186_() + 1.0;
        for (int i = 0; i < 40; ++i) {
            double angle = Math.PI * 2 * (double)i / 40.0;
            double x = mc.f_91074_.m_20185_() + Math.cos(angle) * radius;
            double z = mc.f_91074_.m_20189_() + Math.sin(angle) * radius;
            mc.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static float getCurrentDistance() {
        return currentMode.getDistance();
    }

    public static Mode getCurrentMode() {
        return currentMode;
    }

    public static void updateModeFromServer(Mode mode) {
        currentMode = mode;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Mode {
        WHISPER("label.simplevoicedistance.whisper"){

            @Override
            public float getDistance() {
                return ((Double)ServerConfig.SERVER.whisperDistance.get()).floatValue();
            }
        }
        ,
        NORMAL("label.simplevoicedistance.normal"){

            @Override
            public float getDistance() {
                return ((Double)ServerConfig.SERVER.normalDistance.get()).floatValue();
            }
        }
        ,
        SHOUT("label.simplevoicedistance.shout"){

            @Override
            public float getDistance() {
                return ((Double)ServerConfig.SERVER.shoutDistance.get()).floatValue();
            }
        };

        public final String labelKey;

        private Mode(String labelKey) {
            this.labelKey = labelKey;
        }

        public abstract float getDistance();
    }
}

